/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.PushCommandKt;
import in.specmatic.core.Configuration;
import in.specmatic.core.Result;
import in.specmatic.core.git.NonZeroExitError;
import in.specmatic.core.git.SystemGit;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.utilities.ContractSource;
import in.specmatic.core.utilities.ContractSourceKt;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.Value;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import picocli.CommandLine;

@CommandLine.Command(name="subscribe", mixinStandardHelpOptions=true, description={"Register for the project pipeline to be executed when a contract changes"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0002H\u0016\u00a8\u0006\u0005"}, d2={"Lapplication/SubscribeCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "call", "application"})
public final class SubscribeCommand
implements Callable<Unit> {
    @Override
    public void call() {
        List list;
        JSONObjectValue jSONObjectValue;
        File userHome = new File(System.getProperty("user.home"));
        File workingDirectory = FilesKt.resolve((File)userHome, (String)".specmatic/repos");
        File manifestFile = new File(Configuration.Companion.getGlobalConfigFileName());
        try {
            jSONObjectValue = Utilities.loadConfigJSON((File)manifestFile);
        }
        catch (ContractException e) {
            Utilities.exitWithMessage((String)Result.toReport$default((Result)((Result)e.failure()), null, (int)1, null).toText());
            throw new KotlinNothingValueException();
        }
        JSONObjectValue manifestData = jSONObjectValue;
        try {
            list = Utilities.loadSources((JSONObjectValue)manifestData);
        }
        catch (ContractException e) {
            Utilities.exitWithMessage((String)Result.toReport$default((Result)((Result)e.failure()), null, (int)1, null).toText());
            throw new KotlinNothingValueException();
        }
        List sources = list;
        for (ContractSource source : sources) {
            File sourceDir = source.directoryRelativeTo(workingDirectory);
            String string = sourceDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            SystemGit sourceGit = new SystemGit(string, null, null, 6, null);
            try {
                if (!sourceGit.workingDirectoryIsGitRepo()) continue;
                sourceGit.pull();
                for (String contract : CollectionsKt.plus((Collection)source.getTestContracts(), (Iterable)source.getStubContracts())) {
                    File contractPath = FilesKt.resolve((File)sourceDir, (File)new File(contract));
                    Value value = (Value)manifestData;
                    String string2 = FilesKt.resolve((File)sourceDir, (File)contractPath).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    PushCommandKt.subscribeToContract(value, string2, sourceGit);
                }
                ContractSourceKt.commitAndPush((SystemGit)sourceGit);
            }
            catch (NonZeroExitError e) {
                System.out.println((Object)("Couldn't push the latest. Got error: " + Utilities.exceptionCauseMessage((Throwable)e)));
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
    }
}

