/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Bundle;
import application.BundleCommand_Jvm;
import application.FileOperations;
import application.SpecmaticConfig;
import application.ZipperEntry;
import in.specmatic.core.utilities.ContractPathData;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lapplication/TestBundle;", "Lapplication/Bundle;", "bundlePath", "", "config", "Lapplication/SpecmaticConfig;", "fileOperations", "Lapplication/FileOperations;", "(Ljava/lang/String;Lapplication/SpecmaticConfig;Lapplication/FileOperations;)V", "getBundlePath", "()Ljava/lang/String;", "ancillaryEntries", "", "Lapplication/ZipperEntry;", "pathData", "Lin/specmatic/core/utilities/ContractPathData;", "configEntry", "contractPathData", "application"})
public final class TestBundle
implements Bundle {
    @NotNull
    private final SpecmaticConfig config;
    @NotNull
    private final FileOperations fileOperations;
    @NotNull
    private final String bundlePath;

    public TestBundle(@Nullable String bundlePath, @NotNull SpecmaticConfig config, @NotNull FileOperations fileOperations) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)fileOperations, (String)"fileOperations");
        this.config = config;
        this.fileOperations = fileOperations;
        String string = bundlePath;
        if (string == null) {
            string = "./test-bundle.zip";
        }
        this.bundlePath = string;
    }

    @Override
    @NotNull
    public String getBundlePath() {
        return this.bundlePath;
    }

    @Override
    @NotNull
    public List<ContractPathData> contractPathData() {
        return this.config.contractTestPathData();
    }

    @Override
    @NotNull
    public List<ZipperEntry> ancillaryEntries(@NotNull ContractPathData pathData) {
        List list;
        Intrinsics.checkNotNullParameter((Object)pathData, (String)"pathData");
        File base = new File(pathData.getBaseDir());
        if (BundleCommand_Jvm.access$yamlExists(pathData.getPath())) {
            File yamlFilePath = new File(BundleCommand_Jvm.access$yamlFileName(pathData.getPath()));
            String yamlRelativePath = FilesKt.relativeTo((File)yamlFilePath, (File)base).getPath();
            String yamlEntryName = base.getName() + "/" + yamlRelativePath;
            String string = yamlFilePath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            ZipperEntry yamlEntry = new ZipperEntry(yamlEntryName, this.fileOperations.readBytes(string));
            list = CollectionsKt.listOf((Object)yamlEntry);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<ZipperEntry> configEntry() {
        String configEntryName = new File(this.config.getConfigFilePath()).getName();
        byte[] configContent = this.fileOperations.readBytes(this.config.getConfigFilePath());
        Intrinsics.checkNotNull((Object)configEntryName);
        return CollectionsKt.listOf((Object)new ZipperEntry(configEntryName, configContent));
    }
}

