/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.TestCommandKt;
import application.test.ContractExecutionListener;
import in.specmatic.core.Configuration;
import in.specmatic.core.Flags;
import in.specmatic.core.log.LogStrategy;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.log.Verbose;
import in.specmatic.core.pattern.ContractException;
import in.specmatic.core.utilities.Utilities;
import in.specmatic.test.SpecmaticJUnitSupport;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.reporting.legacy.xml.LegacyXmlReportGeneratingListener;
import org.springframework.beans.factory.annotation.Autowired;
import picocli.CommandLine;

@CommandLine.Command(name="test", mixinStandardHelpOptions=true, description={"Run contract as tests"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u000f\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010C\u001a\u00020\u0002H\u0016J\b\u0010D\u001a\u00020\u0002H\u0002J\u0010\u0010E\u001a\u00020\u00022\u0006\u0010F\u001a\u00020\u0005H\u0002R \u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001e\u0010\u0013\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u001e\u0010\u0016\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u001e\u0010\u0019\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0007\"\u0004\b\u001b\u0010\tR\u001e\u0010\u001c\u001a\u00020\u001d8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R \u0010\"\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0007\"\u0004\b$\u0010\tR\u001e\u0010%\u001a\u00020&8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001e\u0010+\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0007\"\u0004\b-\u0010\tR\u001e\u0010.\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0007\"\u0004\b0\u0010\tR\u001e\u00101\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0007\"\u0004\b3\u0010\tR\u001e\u00104\u001a\u00020&8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010(\"\u0004\b6\u0010*R\u001e\u00107\u001a\u0002088\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R \u0010=\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0007\"\u0004\b?\u0010\tR\u001e\u0010@\u001a\u0002088\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010:\"\u0004\bB\u0010<\u00a8\u0006G"}, d2={"Lapplication/TestCommand;", "Ljava/util/concurrent/Callable;", "", "()V", "configFileName", "", "getConfigFileName", "()Ljava/lang/String;", "setConfigFileName", "(Ljava/lang/String;)V", "contractPaths", "", "getContractPaths", "()Ljava/util/List;", "setContractPaths", "(Ljava/util/List;)V", "envName", "getEnvName", "setEnvName", "filterName", "getFilterName", "setFilterName", "filterNotName", "getFilterNotName", "setFilterNotName", "host", "getHost", "setHost", "junitLauncher", "Lorg/junit/platform/launcher/Launcher;", "getJunitLauncher", "()Lorg/junit/platform/launcher/Launcher;", "setJunitLauncher", "(Lorg/junit/platform/launcher/Launcher;)V", "junitReportDirName", "getJunitReportDirName", "setJunitReportDirName", "port", "", "getPort", "()I", "setPort", "(I)V", "suggestions", "getSuggestions", "setSuggestions", "suggestionsPath", "getSuggestionsPath", "setSuggestionsPath", "testBaseURL", "getTestBaseURL", "setTestBaseURL", "timeout", "getTimeout", "setTimeout", "useHttps", "", "getUseHttps", "()Z", "setUseHttps", "(Z)V", "variablesFileName", "getVariablesFileName", "setVariablesFileName", "verboseMode", "getVerboseMode", "setVerboseMode", "call", "setParallelism", "validateParallelism", "parallelism", "application"})
public final class TestCommand
implements Callable<Unit> {
    @Autowired
    public Launcher junitLauncher;
    @CommandLine.Parameters(description={"Contract file paths"}, arity="0..*")
    @NotNull
    private List<String> contractPaths = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--host"}, description={"The host to bind to, e.g. localhost or some locally bound IP"}, defaultValue="localhost")
    public String host;
    @CommandLine.Option(names={"--port"}, description={"The port to bind to"})
    private int port;
    @CommandLine.Option(names={"--testBaseURL"}, description={"The base URL, use this instead of host and port"}, defaultValue="")
    public String testBaseURL;
    @CommandLine.Option(names={"--suggestionsPath"}, description={"Location of the suggestions file"}, defaultValue="")
    public String suggestionsPath;
    @CommandLine.Option(names={"--suggestions"}, description={"A json value with scenario name and multiple suggestions"}, defaultValue="")
    @NotNull
    private String suggestions = "";
    @CommandLine.Option(names={"--filter-name"}, description={"Run only tests with this value in their name"}, defaultValue="${env:SPECMATIC_FILTER_NAME}")
    @NotNull
    private String filterName = "";
    @CommandLine.Option(names={"--filter-not-name"}, description={"Run only tests which do not have this value in their name"}, defaultValue="${env:SPECMATIC_FILTER_NOT_NAME}")
    @NotNull
    private String filterNotName = "";
    @CommandLine.Option(names={"--env"}, description={"Environment name"})
    @NotNull
    private String envName = "";
    @CommandLine.Option(names={"--https"}, required=false, description={"Use https instead of the default http"})
    private boolean useHttps;
    @CommandLine.Option(names={"--timeout"}, required=false, description={"Specify a timeout for the test requests"}, defaultValue="60")
    private int timeout = 60;
    @CommandLine.Option(names={"--junitReportDir"}, description={"Create junit xml reports in this directory"})
    @Nullable
    private String junitReportDirName;
    @CommandLine.Option(names={"--config"}, description={"Configuration file name (specmatic.json by default)"})
    @Nullable
    private String configFileName;
    @CommandLine.Option(names={"--variables"}, description={"Variables file name (specmatic.json by default)"})
    @Nullable
    private String variablesFileName;
    @CommandLine.Option(names={"--debug"}, description={"Debug logs"})
    private boolean verboseMode;

    @NotNull
    public final Launcher getJunitLauncher() {
        Launcher launcher = this.junitLauncher;
        if (launcher != null) {
            return launcher;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"junitLauncher");
        return null;
    }

    public final void setJunitLauncher(@NotNull Launcher launcher) {
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"<set-?>");
        this.junitLauncher = launcher;
    }

    @NotNull
    public final List<String> getContractPaths() {
        return this.contractPaths;
    }

    public final void setContractPaths(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.contractPaths = list;
    }

    @NotNull
    public final String getHost() {
        String string = this.host;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"host");
        return null;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getTestBaseURL() {
        String string = this.testBaseURL;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"testBaseURL");
        return null;
    }

    public final void setTestBaseURL(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.testBaseURL = string;
    }

    @NotNull
    public final String getSuggestionsPath() {
        String string = this.suggestionsPath;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"suggestionsPath");
        return null;
    }

    public final void setSuggestionsPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.suggestionsPath = string;
    }

    @NotNull
    public final String getSuggestions() {
        return this.suggestions;
    }

    public final void setSuggestions(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.suggestions = string;
    }

    @NotNull
    public final String getFilterName() {
        return this.filterName;
    }

    public final void setFilterName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.filterName = string;
    }

    @NotNull
    public final String getFilterNotName() {
        return this.filterNotName;
    }

    public final void setFilterNotName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.filterNotName = string;
    }

    @NotNull
    public final String getEnvName() {
        return this.envName;
    }

    public final void setEnvName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.envName = string;
    }

    public final boolean getUseHttps() {
        return this.useHttps;
    }

    public final void setUseHttps(boolean bl) {
        this.useHttps = bl;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(int n) {
        this.timeout = n;
    }

    @Nullable
    public final String getJunitReportDirName() {
        return this.junitReportDirName;
    }

    public final void setJunitReportDirName(@Nullable String string) {
        this.junitReportDirName = string;
    }

    @Nullable
    public final String getConfigFileName() {
        return this.configFileName;
    }

    public final void setConfigFileName(@Nullable String string) {
        this.configFileName = string;
    }

    @Nullable
    public final String getVariablesFileName() {
        return this.variablesFileName;
    }

    public final void setVariablesFileName(@Nullable String string) {
        this.variablesFileName = string;
    }

    public final boolean getVerboseMode() {
        return this.verboseMode;
    }

    public final void setVerboseMode(boolean bl) {
        this.verboseMode = bl;
    }

    @Override
    public void call() {
        try {
            this.setParallelism();
            if (this.verboseMode) {
                LoggingKt.setLogger((LogStrategy)((LogStrategy)new Verbose(null, 1, null)));
            }
            String string = this.configFileName;
            if (string != null) {
                String it = string;
                boolean bl = false;
                Configuration.Companion.setGlobalConfigFileName(it);
                System.setProperty("manifestFile", it);
            }
            if (this.port == 0) {
                this.port = this.useHttps ? 443 : 9000;
            }
            String protocol = this.port == 443 ? "https" : (this.useHttps ? "https" : "http");
            System.setProperty("host", this.getHost());
            System.setProperty("port", String.valueOf(this.port));
            System.setProperty("timeout", String.valueOf(this.timeout));
            System.setProperty("suggestionsPath", this.getSuggestionsPath());
            System.setProperty("suggestions", this.suggestions);
            System.setProperty("environment", this.envName);
            System.setProperty("protocol", protocol);
            if (!StringsKt.isBlank((CharSequence)this.filterName)) {
                System.setProperty("filterName", this.filterName);
            }
            if (!StringsKt.isBlank((CharSequence)this.filterNotName)) {
                System.setProperty("filterNotName", this.filterNotName);
            }
            String string2 = this.variablesFileName;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                System.setProperty("variablesFileName", it);
            }
            if (((CharSequence)this.getTestBaseURL()).length() > 0) {
                System.setProperty("testBaseURL", this.getTestBaseURL());
            }
            if (!((Collection)this.contractPaths).isEmpty()) {
                System.setProperty("contractPaths", CollectionsKt.joinToString$default((Iterable)this.contractPaths, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
            DiscoverySelector[] discoverySelectorArray = new DiscoverySelector[]{DiscoverySelectors.selectClass(SpecmaticJUnitSupport.class)};
            LauncherDiscoveryRequest launcherDiscoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(discoverySelectorArray).build();
            Intrinsics.checkNotNullExpressionValue((Object)launcherDiscoveryRequest, (String)"build(...)");
            LauncherDiscoveryRequest request = launcherDiscoveryRequest;
            this.getJunitLauncher().discover(request);
            ContractExecutionListener contractExecutionListener = new ContractExecutionListener();
            discoverySelectorArray = new TestExecutionListener[]{contractExecutionListener};
            this.getJunitLauncher().registerTestExecutionListeners((TestExecutionListener[])discoverySelectorArray);
            String string3 = this.junitReportDirName;
            if (string3 != null) {
                String dirName = string3;
                boolean bl = false;
                LegacyXmlReportGeneratingListener reportListener = new LegacyXmlReportGeneratingListener(Paths.get(dirName, new String[0]), new PrintWriter(System.out, true));
                TestExecutionListener[] testExecutionListenerArray = new TestExecutionListener[]{reportListener};
                this.getJunitLauncher().registerTestExecutionListeners(testExecutionListenerArray);
            }
            this.getJunitLauncher().execute(request, new TestExecutionListener[0]);
            String string4 = this.junitReportDirName;
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                File reportDirectory = new File(it);
                File reportFile = FilesKt.resolve((File)reportDirectory, (String)"TEST-junit-jupiter.xml");
                if (reportFile.isFile()) {
                    String updatedJUnitXML = TestCommandKt.updateNamesInJUnitXML(FilesKt.readText$default((File)reportFile, null, (int)1, null));
                    FilesKt.writeText$default((File)reportFile, (String)updatedJUnitXML, null, (int)2, null);
                } else {
                    throw new ContractException("Was expecting a JUnit report file called TEST-junit-jupiter.xml inside " + this.junitReportDirName + " but could not find it.", null, null, null, false, 30, null);
                }
            }
            contractExecutionListener.exitProcess();
        }
        catch (Throwable e) {
            LogStrategy.DefaultImpls.log$default((LogStrategy)LoggingKt.getLogger(), (Throwable)e, null, (int)2, null);
        }
    }

    private final void setParallelism() {
        String string = Flags.INSTANCE.testParallelism();
        if (string != null) {
            String parallelism = string;
            boolean bl = false;
            this.validateParallelism(parallelism);
            System.setProperty("junit.jupiter.execution.parallel.enabled", "true");
            if (Intrinsics.areEqual((Object)parallelism, (Object)"auto")) {
                LoggingKt.getLogger().log("Running contract tests in parallel (dynamically determined number of threads)");
                v1 = System.setProperty("junit.jupiter.execution.parallel.config.strategy", "dynamic");
            } else {
                LoggingKt.getLogger().log("Running contract tests in parallel in " + parallelism + " threads");
                System.setProperty("junit.jupiter.execution.parallel.config.strategy", "fixed");
                v1 = System.setProperty("junit.jupiter.execution.parallel.config.fixed.parallelism", parallelism);
            }
        } else {
            v1 = null;
        }
    }

    private final void validateParallelism(String parallelism) {
        if (Intrinsics.areEqual((Object)parallelism, (Object)"auto")) {
            return;
        }
        try {
            Integer.parseInt(parallelism);
        }
        catch (Throwable e) {
            Utilities.exitWithMessage((String)"The value of the SPECMATIC_TEST_PARALLELISM environment variable must be either 'true' or an integer value");
            throw new KotlinNothingValueException();
        }
    }
}

