/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.FileOperations;
import in.specmatic.core.Feature;
import in.specmatic.core.FeatureKt;
import in.specmatic.core.log.HeadingLog;
import in.specmatic.core.log.LogMessage;
import in.specmatic.core.log.LogStrategy;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.log.Verbose;
import in.specmatic.core.utilities.Utilities;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.util.concurrent.Callable;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import picocli.CommandLine;

@CommandLine.Command(name="to-openapi", mixinStandardHelpOptions=true, description={"Converts a Gherkin file to OpenAPI"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0002H\u0016R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lapplication/ToOpenAPICommand;", "Ljava/util/concurrent/Callable;", "", "()V", "contractPath", "", "getContractPath", "()Ljava/lang/String;", "setContractPath", "(Ljava/lang/String;)V", "fileOperations", "Lapplication/FileOperations;", "getFileOperations", "()Lapplication/FileOperations;", "setFileOperations", "(Lapplication/FileOperations;)V", "verbose", "", "getVerbose", "()Z", "setVerbose", "(Z)V", "call", "application"})
public final class ToOpenAPICommand
implements Callable<Unit> {
    @CommandLine.Parameters(description={"Path in which to create the bundle"})
    public String contractPath;
    @CommandLine.Option(names={"--debug"})
    private boolean verbose;
    @Autowired
    public FileOperations fileOperations;

    @NotNull
    public final String getContractPath() {
        String string = this.contractPath;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"contractPath");
        return null;
    }

    public final void setContractPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.contractPath = string;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @NotNull
    public final FileOperations getFileOperations() {
        FileOperations fileOperations = this.fileOperations;
        if (fileOperations != null) {
            return fileOperations;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fileOperations");
        return null;
    }

    public final void setFileOperations(@NotNull FileOperations fileOperations) {
        Intrinsics.checkNotNullParameter((Object)fileOperations, (String)"<set-?>");
        this.fileOperations = fileOperations;
    }

    @Override
    public void call() {
        if (this.verbose) {
            LoggingKt.setLogger((LogStrategy)((LogStrategy)new Verbose(null, 1, null)));
        }
        LoggingKt.getLogger().keepReady((LogMessage)new HeadingLog(this.getContractPath()));
        if (!this.getFileOperations().isFile(this.getContractPath())) {
            Utilities.exitWithMessage((String)(this.getContractPath() + " is not a file"));
            throw new KotlinNothingValueException();
        }
        try {
            Feature gherkinContract = FeatureKt.parseGherkinStringToFeature$default((String)this.getFileOperations().read(this.getContractPath()), null, (int)2, null);
            OpenAPI openAPI = gherkinContract.toOpenApi();
            String openAPIYaml = Yaml.pretty((Object)openAPI);
            File contractFile = new File(this.getContractPath());
            File file2 = contractFile.getCanonicalFile().getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
            File openAPIFile = FilesKt.resolve((File)file2, (String)(FilesKt.getNameWithoutExtension((File)contractFile) + ".yaml"));
            Intrinsics.checkNotNull((Object)openAPIYaml);
            FilesKt.writeText$default((File)openAPIFile, (String)openAPIYaml, null, (int)2, null);
        }
        catch (Throwable e) {
            LogStrategy.DefaultImpls.log$default((LogStrategy)LoggingKt.getLogger(), (Throwable)e, null, (int)2, null);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }
}

