/*
 * Decompiled with CFR 0.152.
 */
package application;

import in.specmatic.conversions.OpenApiSpecification;
import in.specmatic.core.Feature;
import in.specmatic.core.HttpPathPattern;
import in.specmatic.core.HttpRequest;
import in.specmatic.core.HttpResponse;
import in.specmatic.core.Resolver;
import in.specmatic.core.Result;
import in.specmatic.core.Scenario;
import in.specmatic.core.log.LoggingKt;
import in.specmatic.core.pattern.GrammarKt;
import in.specmatic.core.value.JSONArrayValue;
import in.specmatic.core.value.JSONObjectValue;
import in.specmatic.core.value.Value;
import in.specmatic.mock.NoMatchingScenario;
import in.specmatic.mock.ScenarioStub;
import in.specmatic.mock.ScenarioStubKt;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import picocli.CommandLine;

@CommandLine.Command(name="validate-via-logs", mixinStandardHelpOptions=true, description={"Validate a contract against log files to ensure that the contract matches all valid logs, stubs and requests"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0002H\u0016J\"\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00130\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J8\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00130\u0012H\u0002J4\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00130\u0012H\u0002J4\u0010\u001f\u001a\u0004\u0018\u00010\u00192\u0006\u0010 \u001a\u00020\u00052\u0018\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00130\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001e\u0010\r\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\t\u00a8\u0006!"}, d2={"Lapplication/ValidateViaLogs;", "Ljava/util/concurrent/Callable;", "", "()V", "contractPath", "", "getContractPath", "()Ljava/lang/String;", "setContractPath", "(Ljava/lang/String;)V", "logDirPath", "getLogDirPath", "setLogDirPath", "urlPathFilter", "getUrlPathFilter", "setUrlPathFilter", "call", "findMatchingURLMatchers", "", "Lkotlin/Pair;", "Lin/specmatic/core/HttpPathPattern;", "Lin/specmatic/core/Resolver;", "feature", "Lin/specmatic/core/Feature;", "stubFromExpectationLog", "Lin/specmatic/mock/ScenarioStub;", "log", "Lin/specmatic/core/value/JSONObjectValue;", "httpUrlMatchers", "stubRequestPathLog", "Lin/specmatic/core/value/Value;", "stubFromRequestLog", "path", "application"})
@SourceDebugExtension(value={"SMAP\nValidateViaLogs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidateViaLogs.kt\napplication/ValidateViaLogs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1603#2,9:153\n1855#2:162\n1856#2:165\n1612#2:166\n1549#2:167\n1620#2,3:168\n766#2:171\n857#2,2:172\n1855#2,2:174\n1747#2,3:176\n1747#2,3:179\n1549#2:182\n1620#2,3:183\n1549#2:186\n1620#2,3:187\n766#2:190\n857#2,2:191\n1549#2:193\n1620#2,3:194\n1#3:163\n1#3:164\n*S KotlinDebug\n*F\n+ 1 ValidateViaLogs.kt\napplication/ValidateViaLogs\n*L\n39#1:153,9\n39#1:162\n39#1:165\n39#1:166\n49#1:167\n49#1:168,3\n59#1:171\n59#1:172,2\n69#1:174,2\n113#1:176,3\n132#1:179,3\n141#1:182\n141#1:183,3\n143#1:186\n143#1:187,3\n145#1:190\n145#1:191,2\n147#1:193\n147#1:194,3\n39#1:164\n*E\n"})
public final class ValidateViaLogs
implements Callable<Unit> {
    @CommandLine.Parameters(index="0", description={"Contract path"})
    public String contractPath;
    @CommandLine.Parameters(index="1", description={"Log directory path"})
    public String logDirPath;
    @CommandLine.Parameters(index="2", description={"urlPathFilter"})
    public String urlPathFilter;

    @NotNull
    public final String getContractPath() {
        String string = this.contractPath;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"contractPath");
        return null;
    }

    public final void setContractPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.contractPath = string;
    }

    @NotNull
    public final String getLogDirPath() {
        String string = this.logDirPath;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"logDirPath");
        return null;
    }

    public final void setLogDirPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.logDirPath = string;
    }

    @NotNull
    public final String getUrlPathFilter() {
        String string = this.urlPathFilter;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"urlPathFilter");
        return null;
    }

    public final void setUrlPathFilter(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.urlPathFilter = string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void call() {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Feature feature = OpenApiSpecification.Companion.fromFile(this.getContractPath()).toFeature();
        List<Pair<HttpPathPattern, Resolver>> httpUrlMatchers = this.findMatchingURLMatchers(feature);
        JSONArrayValue requestLogs = GrammarKt.parsedJSONArray$default((String)FilesKt.readText$default((File)new File(this.getLogDirPath()), null, (int)1, null), null, (int)2, null);
        Iterable $this$mapNotNull$iv = requestLogs.getList();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<Pair> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Triple triple = $this$forEach$iv$iv$iv.iterator();
        while (triple.hasNext()) {
            Pair pair;
            String path;
            Object element$iv$iv = element$iv$iv$iv = triple.next();
            boolean bl = false;
            Value requestLog = (Value)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)requestLog, (String)"null cannot be cast to non-null type in.specmatic.core.value.JSONObjectValue");
            JSONObjectValue log = (JSONObjectValue)requestLog;
            Value value = log.findFirstChildByPath("http-request.path");
            String string = path = value != null ? value.toStringLiteral() : null;
            if (Intrinsics.areEqual((Object)path, (Object)"/_specmatic/expectations")) {
                pair = this.stubFromExpectationLog(log, httpUrlMatchers);
            } else if (path == null) {
                pair = null;
            } else if (this.stubFromRequestLog(path, httpUrlMatchers, log) != null) {
                ScenarioStub it;
                boolean bl3 = false;
                pair = new Pair((Object)ScenarioStubKt.mockFromJSON((Map)log.getJsonObject()), (Object)it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List stubsMatchingURLs = (List)destination$iv$iv;
        Iterable $this$map$iv = stubsMatchingURLs;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Triple triple2;
            element$iv$iv$iv = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            ScenarioStub container = (ScenarioStub)element$iv$iv$iv.component1();
            ScenarioStub matchingScenario = (ScenarioStub)element$iv$iv$iv.component2();
            try {
                Feature.matchingStub$default((Feature)feature, (HttpRequest)matchingScenario.getRequest(), (HttpResponse)matchingScenario.getResponse(), null, (int)4, null);
                triple2 = new Triple((Object)new Result.Success(null, null, 3, null), (Object)container, (Object)matchingScenario);
            }
            catch (NoMatchingScenario e) {
                triple2 = new Triple((Object)e.getResults().toResultIfAny(), (Object)container, (Object)matchingScenario);
            }
            collection.add(triple2);
        }
        List matchResults = (List)destination$iv$iv2;
        Iterable $this$filter$iv = matchResults;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Triple it = (Triple)element$iv$iv;
            boolean bl = false;
            if (!(it.getFirst() instanceof Result.Failure)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List matchFailures = (List)destination$iv$iv3;
        int countOfSuccessfulMatches = matchResults.size() - matchFailures.size();
        if (matchFailures.isEmpty()) {
            LoggingKt.getLogger().log("The contract is compatible with all stubs");
        } else {
            LoggingKt.getLogger().log("The contract is not compatible with the following:");
            Iterable $this$forEach$iv = matchFailures;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                triple = (Triple)element$iv;
                boolean bl = false;
                Result result = (Result)triple.component1();
                ScenarioStub container = (ScenarioStub)triple.component2();
                LoggingKt.getLogger().log("--------------------");
                LoggingKt.getLogger().log(container.toJSON().toStringLiteral());
                LoggingKt.getLogger().log(result.reportString());
                LoggingKt.getLogger().newLine();
            }
        }
        LoggingKt.getLogger().newLine();
        LoggingKt.getLogger().log("Matched " + matchResults.size() + ", Succeeded: " + countOfSuccessfulMatches + ", Failed: " + matchFailures.size());
        LoggingKt.getLogger().newLine();
    }

    private final Pair<ScenarioStub, ScenarioStub> stubFromExpectationLog(JSONObjectValue log, List<Pair<HttpPathPattern, Resolver>> httpUrlMatchers) {
        String status;
        Value value = log.findFirstChildByPath("http-response.status");
        String string = status = value != null ? value.toStringLiteral() : null;
        if (!Intrinsics.areEqual((Object)status, (Object)"200")) {
            return null;
        }
        Value value2 = log.findFirstChildByPath("http-request.body.http-request.path");
        if (value2 != null) {
            Value stubRequestPathLog = value2;
            boolean bl = false;
            Value value3 = log.findFirstChildByPath("http-response.status");
            if (Intrinsics.areEqual((Object)(value3 != null ? value3.toStringLiteral() : null), (Object)"200")) {
                Pair pair;
                ScenarioStub scenarioStub = this.stubFromExpectationLog(stubRequestPathLog, log, httpUrlMatchers);
                if (scenarioStub != null) {
                    ScenarioStub it = scenarioStub;
                    boolean bl2 = false;
                    pair = new Pair((Object)ScenarioStubKt.mockFromJSON((Map)log.getJsonObject()), (Object)it);
                } else {
                    pair = null;
                }
                return pair;
            }
        }
        return null;
    }

    private final ScenarioStub stubFromExpectationLog(Value stubRequestPathLog, JSONObjectValue log, List<Pair<HttpPathPattern, Resolver>> httpUrlMatchers) {
        boolean bl;
        JSONObjectValue body;
        block4: {
            String path = stubRequestPathLog.toStringLiteral();
            Value value = log.findFirstChildByPath("http-request.body");
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type in.specmatic.core.value.JSONObjectValue");
            body = (JSONObjectValue)value;
            Iterable $this$any$iv = httpUrlMatchers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Resolver resolver;
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    HttpPathPattern matcher = (HttpPathPattern)pair.component1();
                    if (!(matcher.matches(path, resolver = (Resolver)pair.component2()) instanceof Result.Success)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return ScenarioStubKt.mockFromJSON((Map)body.getJsonObject());
        }
        return null;
    }

    private final ScenarioStub stubFromRequestLog(String path, List<Pair<HttpPathPattern, Resolver>> httpUrlMatchers, JSONObjectValue log) {
        boolean bl;
        block5: {
            String specmaticResult;
            JSONObjectValue headers = (JSONObjectValue)log.findFirstChildByPath("http-response.headers");
            Object object = headers;
            String string = object != null && (object = object.getJsonObject()) != null && (object = (Value)object.get("X-Specmatic-Result")) != null ? object.toStringLiteral() : (specmaticResult = null);
            if (!Intrinsics.areEqual(specmaticResult, (Object)"success")) {
                return null;
            }
            Iterable $this$any$iv = httpUrlMatchers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Resolver resolver;
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    HttpPathPattern matcher = (HttpPathPattern)pair.component1();
                    if (!(matcher.matches(path, resolver = (Resolver)pair.component2()) instanceof Result.Success)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return ScenarioStubKt.mockFromJSON((Map)log.getJsonObject());
        }
        return null;
    }

    private final List<Pair<HttpPathPattern, Resolver>> findMatchingURLMatchers(Feature feature) {
        Iterable $this$filterTo$iv$iv;
        Pair it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = feature.getScenarios();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Scenario scenario = (Scenario)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)it.getHttpRequestPattern().getHttpPathPattern(), (Object)it.getResolver()));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Result result;
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            HttpPathPattern matcher = (HttpPathPattern)it.component1();
            Resolver resolver = (Resolver)it.component2();
            HttpPathPattern httpPathPattern = matcher;
            if (httpPathPattern != null) {
                URI uRI = URI.create(this.getUrlPathFilter());
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                result = HttpPathPattern.matches$default((HttpPathPattern)httpPathPattern, (URI)uRI, null, (int)2, null);
            } else {
                result = null;
            }
            collection.add(new Triple((Object)matcher, result, (Object)resolver));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Triple)element$iv$iv;
            boolean bl = false;
            if (!(it.getSecond() instanceof Result.Success)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Triple)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Object object = it.getFirst();
            Intrinsics.checkNotNull((Object)object);
            collection.add(new Pair(object, it.getThird()));
        }
        List httpUrlMatchers = (List)destination$iv$iv;
        return httpUrlMatchers;
    }
}

