/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.configuration;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import info.archinnov.achilles.annotations.Entity;
import info.archinnov.achilles.configuration.ConfigurationParameters;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.interceptor.Interceptor;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.utils.ConfigMap;
import info.archinnov.achilles.json.DefaultJacksonMapperFactory;
import info.archinnov.achilles.json.JacksonMapperFactory;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.InsertStrategy;
import info.archinnov.achilles.type.NamingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgumentExtractor {
    private static final Logger log = LoggerFactory.getLogger(ArgumentExtractor.class);
    static final ConsistencyLevel DEFAULT_LEVEL = ConsistencyLevel.ONE;
    static final int DEFAULT_LRU_CACHE_SIZE = 10000;
    static final boolean DEFAULT_ENABLE_BEAN_VALIDATION = false;
    static final boolean DEFAULT_PROXIES_WARM_UP_DISABLED = true;
    static final boolean DEFAULT_INDEX_RELAX_VALIDATION = false;
    static final InsertStrategy DEFAULT_INSERT_STRATEGY = InsertStrategy.ALL_FIELDS;
    static final NamingStrategy DEFAULT_GLOBAL_NAMING_STRATEGY = NamingStrategy.LOWER_CASE;
    static final ExecutorService DEFAULT_EXECUTOR_SERVICE = Executors.newCachedThreadPool();

    public List<Class<?>> initEntities(ConfigMap configurationMap, ClassLoader classLoader) {
        log.trace("Extract entities from configuration map");
        List<String> entityPackages = this.getEntityPackages(configurationMap);
        List<Class<?>> entities = this.discoverEntities(entityPackages, classLoader);
        List entitiesFromList = configurationMap.getTypedOr(ConfigurationParameters.ENTITIES_LIST, Collections.emptyList());
        entities.addAll(entitiesFromList);
        return entities;
    }

    private List<String> getEntityPackages(ConfigMap configurationMap) {
        log.trace("Extract entity packages from configuration map");
        List<String> entityPackages = new ArrayList<String>();
        String entityPackagesParameter = (String)configurationMap.getTyped(ConfigurationParameters.ENTITY_PACKAGES);
        if (StringUtils.isNotBlank((CharSequence)entityPackagesParameter)) {
            entityPackages = Arrays.asList(StringUtils.split((String)entityPackagesParameter, (String)","));
        }
        return entityPackages;
    }

    private List<Class<?>> discoverEntities(List<String> packageNames, ClassLoader classLoader) {
        log.debug("Discovery of Achilles entity classes in packages {}", (Object)StringUtils.join(packageNames, (String)","));
        HashSet candidateClasses = new HashSet();
        if (!packageNames.isEmpty()) {
            Reflections reflections = new Reflections(new Object[]{packageNames, classLoader});
            candidateClasses.addAll(reflections.getTypesAnnotatedWith(Entity.class));
        }
        return new ArrayList(candidateClasses);
    }

    public ConfigurationContext initConfigContext(ConfigMap configurationMap) {
        log.trace("Build ConfigurationContext from configuration map");
        ConfigurationContext configContext = new ConfigurationContext();
        configContext.setCurrentKeyspace(this.initKeyspaceName(configurationMap));
        configContext.setForceColumnFamilyCreation(this.initForceTableCreation(configurationMap));
        configContext.setEnableSchemaUpdate(this.initForceTableUpdate(configurationMap));
        configContext.setEnableSchemaUpdateForTables(this.initForceTableUpdateMap(configurationMap));
        configContext.setJacksonMapperFactory(this.initObjectMapperFactory(configurationMap));
        configContext.setDefaultReadConsistencyLevel(this.initDefaultReadConsistencyLevel(configurationMap));
        configContext.setDefaultWriteConsistencyLevel(this.initDefaultWriteConsistencyLevel(configurationMap));
        configContext.setReadConsistencyLevelMap(this.initReadConsistencyMap(configurationMap));
        configContext.setWriteConsistencyLevelMap(this.initWriteConsistencyMap(configurationMap));
        configContext.setBeanValidator(this.initValidator(configurationMap));
        configContext.setPreparedStatementLRUCacheSize(this.initPreparedStatementsCacheSize(configurationMap));
        configContext.setGlobalInsertStrategy(this.initInsertStrategy(configurationMap));
        configContext.setGlobalNamingStrategy(this.initGlobalNamingStrategy(configurationMap));
        configContext.setOSGIClassLoader(this.initOSGIClassLoader(configurationMap));
        configContext.setRelaxIndexValidation(this.initRelaxIndexValidation(configurationMap));
        configContext.setExecutorService(this.initExecutorService(configurationMap));
        return configContext;
    }

    boolean initForceTableCreation(ConfigMap configurationMap) {
        log.trace("Extract 'force table creation' from configuration map");
        return configurationMap.getTypedOr(ConfigurationParameters.FORCE_TABLE_CREATION, false);
    }

    boolean initForceTableUpdate(ConfigMap configurationMap) {
        log.trace("Extract 'force table update' from configuration map");
        return configurationMap.getTypedOr(ConfigurationParameters.ENABLE_SCHEMA_UPDATE, false);
    }

    public Map<String, Boolean> initForceTableUpdateMap(ConfigMap configMap) {
        log.trace("Extract 'force table update' map from configuration map");
        return (Map)configMap.getTypedOr(ConfigurationParameters.ENABLE_SCHEMA_UPDATE_FOR_TABLES, ImmutableMap.of());
    }

    JacksonMapperFactory initObjectMapperFactory(ConfigMap configurationMap) {
        log.trace("Extract object mapper factory from configuration map");
        JacksonMapperFactory jacksonMapperFactory = (JacksonMapperFactory)configurationMap.getTyped(ConfigurationParameters.JACKSON_MAPPER_FACTORY);
        if (jacksonMapperFactory == null) {
            ObjectMapper mapper = (ObjectMapper)configurationMap.getTyped(ConfigurationParameters.JACKSON_MAPPER);
            jacksonMapperFactory = mapper != null ? ArgumentExtractor.factoryFromMapper(mapper) : new DefaultJacksonMapperFactory();
        }
        return jacksonMapperFactory;
    }

    protected static JacksonMapperFactory factoryFromMapper(final ObjectMapper mapper) {
        return new JacksonMapperFactory(){

            @Override
            public <T> ObjectMapper getMapper(Class<T> type) {
                return mapper;
            }
        };
    }

    ConsistencyLevel initDefaultReadConsistencyLevel(ConfigMap configMap) {
        log.trace("Extract default read Consistency level from configuration map");
        return configMap.getTypedOr(ConfigurationParameters.CONSISTENCY_LEVEL_READ_DEFAULT, DEFAULT_LEVEL);
    }

    ConsistencyLevel initDefaultWriteConsistencyLevel(ConfigMap configMap) {
        log.trace("Extract default write Consistency level from configuration map");
        return configMap.getTypedOr(ConfigurationParameters.CONSISTENCY_LEVEL_WRITE_DEFAULT, DEFAULT_LEVEL);
    }

    public Map<String, ConsistencyLevel> initReadConsistencyMap(ConfigMap configMap) {
        log.trace("Extract read Consistency level map from configuration map");
        return (Map)configMap.getTypedOr(ConfigurationParameters.CONSISTENCY_LEVEL_READ_MAP, ImmutableMap.of());
    }

    public Map<String, ConsistencyLevel> initWriteConsistencyMap(ConfigMap configMap) {
        log.trace("Extract write Consistency level map from configuration map");
        return (Map)configMap.getTypedOr(ConfigurationParameters.CONSISTENCY_LEVEL_WRITE_MAP, ImmutableMap.of());
    }

    public Optional<String> initKeyspaceName(ConfigMap configurationMap) {
        return Optional.fromNullable(configurationMap.getTyped(ConfigurationParameters.KEYSPACE_NAME));
    }

    public Session initSession(Cluster cluster, ConfigMap configurationMap) {
        log.trace("Extract or init Session from configuration map");
        Session nativeSession = (Session)configurationMap.getTyped(ConfigurationParameters.NATIVE_SESSION);
        if (nativeSession == null) {
            Optional<String> keyspaceNameO = this.initKeyspaceName(configurationMap);
            nativeSession = keyspaceNameO.isPresent() ? cluster.connect((String)keyspaceNameO.get()) : cluster.connect();
        }
        return nativeSession;
    }

    public List<Interceptor<?>> initInterceptors(ConfigMap configurationMap) {
        ArrayList interceptors = (ArrayList)configurationMap.get((Object)ConfigurationParameters.EVENT_INTERCEPTORS);
        if (interceptors == null) {
            interceptors = new ArrayList();
        }
        return new ArrayList(new LinkedHashSet(interceptors));
    }

    Validator initValidator(ConfigMap configurationMap) {
        Boolean enableBeanValidation = configurationMap.getTypedOr(ConfigurationParameters.BEAN_VALIDATION_ENABLE, false);
        if (enableBeanValidation.booleanValue()) {
            try {
                Validator defaultValidator = Validation.buildDefaultValidatorFactory().getValidator();
                return configurationMap.getTypedOr(ConfigurationParameters.BEAN_VALIDATION_VALIDATOR, defaultValidator);
            }
            catch (ValidationException vex) {
                throw new AchillesException("Cannot bootstrap ValidatorFactory for Bean Validation (JSR 303)", (Throwable)vex);
            }
        }
        return null;
    }

    public Integer initPreparedStatementsCacheSize(ConfigMap configMap) {
        return configMap.getTypedOr(ConfigurationParameters.PREPARED_STATEMENTS_CACHE_SIZE, 10000);
    }

    public boolean initProxyWarmUp(ConfigMap configMap) {
        return configMap.getTypedOr(ConfigurationParameters.PROXIES_WARM_UP_DISABLED, true);
    }

    public InsertStrategy initInsertStrategy(ConfigMap configMap) {
        return configMap.getTypedOr(ConfigurationParameters.GLOBAL_INSERT_STRATEGY, DEFAULT_INSERT_STRATEGY);
    }

    public NamingStrategy initGlobalNamingStrategy(ConfigMap configMap) {
        return configMap.getTypedOr(ConfigurationParameters.GLOBAL_NAMING_STRATEGY, DEFAULT_GLOBAL_NAMING_STRATEGY);
    }

    public ClassLoader initOSGIClassLoader(ConfigMap configMap) {
        return (ClassLoader)configMap.getTyped(ConfigurationParameters.OSGI_CLASS_LOADER);
    }

    public boolean initRelaxIndexValidation(ConfigMap configMap) {
        return configMap.getTypedOr(ConfigurationParameters.RELAX_INDEX_VALIDATION, false);
    }

    public ExecutorService initExecutorService(ConfigMap configMap) {
        return configMap.getTypedOr(ConfigurationParameters.EXECUTOR_SERVICE, DEFAULT_EXECUTOR_SERVICE);
    }
}

