/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.async;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.type.Empty;
import info.archinnov.achilles.type.Options;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.ArrayUtils;

public class AsyncUtils {
    public static final Function<ResultSet, List<Row>> RESULTSET_TO_ROWS = new Function<ResultSet, List<Row>>(){

        public List<Row> apply(ResultSet resultSet) {
            List<Object> rows = new ArrayList<Row>();
            if (resultSet != null) {
                rows = resultSet.all();
            }
            return rows;
        }
    };
    public static final Function<ResultSet, Row> RESULTSET_TO_ROW = new Function<ResultSet, Row>(){

        public Row apply(ResultSet resultSet) {
            Row row = null;
            if (resultSet != null) {
                row = resultSet.one();
            }
            return row;
        }
    };
    public static final Function<ResultSet, Iterator<Row>> RESULTSET_TO_ITERATOR = new Function<ResultSet, Iterator<Row>>(){

        public Iterator<Row> apply(ResultSet resultSet) {
            Iterator iterator = new ArrayList().iterator();
            if (resultSet != null) {
                iterator = resultSet.iterator();
            }
            return iterator;
        }
    };

    public void maybeAddAsyncListeners(ListenableFuture<?> listenableFuture, Options options, ExecutorService executorService) {
        if (options.hasAsyncListeners()) {
            for (FutureCallback<Object> callback : options.getAsyncListeners()) {
                Futures.addCallback(listenableFuture, callback, (Executor)executorService);
            }
        }
    }

    public void maybeAddAsyncListeners(ListenableFuture<?> listenableFuture, FutureCallback<Object>[] asyncListeners, ExecutorService executorService) {
        if (ArrayUtils.isNotEmpty((Object[])asyncListeners)) {
            for (FutureCallback<Object> callback : asyncListeners) {
                Futures.addCallback(listenableFuture, callback, (Executor)executorService);
            }
        }
    }

    public <T, V> ListenableFuture<T> transformFuture(ListenableFuture<V> from, Function<V, T> function, ExecutorService executorService) {
        return Futures.transform(from, function, (Executor)executorService);
    }

    public <V> ListenableFuture<Empty> transformFutureToEmpty(ListenableFuture<V> from, ExecutorService executorService) {
        Function function = new Function<V, Empty>(){

            public Empty apply(V input) {
                return Empty.INSTANCE;
            }
        };
        return Futures.transform(from, (Function)function, (Executor)executorService);
    }

    public <T> AchillesFuture<T> buildInterruptible(ListenableFuture<T> listenableFuture) {
        return new AchillesFuture<T>(listenableFuture);
    }

    public ListenableFuture<List<ResultSet>> mergeResultSetFutures(List<ListenableFuture<ResultSet>> resultSetFutures) {
        return Futures.allAsList(resultSetFutures);
    }

    public ListenableFuture<ResultSet> applyLoggingTracingAndCASCheck(ResultSetFuture resultSetFuture, final AbstractStatementWrapper statementWrapper, ExecutorService executorService) {
        Function<ResultSet, ResultSet> logStatements = new Function<ResultSet, ResultSet>(){

            public ResultSet apply(ResultSet resultSet) {
                statementWrapper.logDMLStatement("");
                return resultSet;
            }
        };
        Function<ResultSet, ResultSet> tracing = new Function<ResultSet, ResultSet>(){

            public ResultSet apply(ResultSet resultSet) {
                statementWrapper.tracing(resultSet);
                return resultSet;
            }
        };
        Function<ResultSet, ResultSet> CASCheck = new Function<ResultSet, ResultSet>(){

            public ResultSet apply(ResultSet resultSet) {
                statementWrapper.checkForCASSuccess(resultSet);
                return resultSet;
            }
        };
        ListenableFuture logApplied = Futures.transform((ListenableFuture)resultSetFuture, (Function)logStatements, (Executor)executorService);
        ListenableFuture tracingApplied = Futures.transform((ListenableFuture)logApplied, (Function)tracing, (Executor)executorService);
        return Futures.transform((ListenableFuture)tracingApplied, (Function)CASCheck, (Executor)executorService);
    }

    public static enum Singleton {
        INSTANCE;

        private final AsyncUtils instance = new AsyncUtils();

        public AsyncUtils get() {
            return this.instance;
        }
    }
}

