/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.async;

import com.datastax.driver.core.ResultSet;
import com.google.common.util.concurrent.FutureCallback;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetListener
implements FutureCallback<ResultSet> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultSetListener.class);
    private AbstractStatementWrapper statementWrapper;

    public ResultSetListener(AbstractStatementWrapper statementWrapper) {
        this.statementWrapper = statementWrapper;
    }

    public void onSuccess(ResultSet resultSet) {
        LOGGER.trace("Apply Logging and maybe invoke CAS listener for resultSet {} and query '{}'", (Object)resultSet.toString(), (Object)this.statementWrapper.getQueryString());
        this.statementWrapper.logDMLStatement("");
        this.statementWrapper.tracing(resultSet);
        this.statementWrapper.checkForCASSuccess(resultSet);
    }

    public void onFailure(Throwable t) {
        LOGGER.error(t.getMessage());
    }
}

