/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.context;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.async.AsyncUtils;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.internal.statement.wrapper.BatchStatementWrapper;
import info.archinnov.achilles.type.Empty;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFlushContext {
    protected AsyncUtils asyncUtils = AsyncUtils.Singleton.INSTANCE.get();
    protected DaoContext daoContext;
    protected List<AbstractStatementWrapper> statementWrappers = new ArrayList<AbstractStatementWrapper>();
    protected List<AbstractStatementWrapper> counterStatementWrappers = new ArrayList<AbstractStatementWrapper>();
    protected info.archinnov.achilles.type.ConsistencyLevel consistencyLevel;
    protected Optional<ConsistencyLevel> serialConsistencyLevel = Optional.absent();

    public AbstractFlushContext(DaoContext daoContext, info.archinnov.achilles.type.ConsistencyLevel consistencyLevel, Optional<ConsistencyLevel> serialConsistencyLevel) {
        this.daoContext = daoContext;
        this.consistencyLevel = consistencyLevel;
        this.serialConsistencyLevel = serialConsistencyLevel;
    }

    protected AbstractFlushContext(DaoContext daoContext, List<AbstractStatementWrapper> statementWrappers, info.archinnov.achilles.type.ConsistencyLevel consistencyLevel, Optional<ConsistencyLevel> serialConsistencyLevel) {
        this.statementWrappers = statementWrappers;
        this.daoContext = daoContext;
        this.consistencyLevel = consistencyLevel;
        this.serialConsistencyLevel = serialConsistencyLevel;
    }

    protected ListenableFuture<ResultSet> executeBatch(BatchStatement.Type batchType, List<AbstractStatementWrapper> statementWrappers) {
        ListenableFuture<ResultSet> resultSetFuture = null;
        int size = statementWrappers.size();
        if (size > 1) {
            BatchStatementWrapper batchStatementWrapper = new BatchStatementWrapper(batchType, statementWrappers, (Optional<info.archinnov.achilles.type.ConsistencyLevel>)Optional.fromNullable((Object)this.consistencyLevel), this.serialConsistencyLevel);
            resultSetFuture = this.daoContext.execute(batchStatementWrapper);
        } else if (size == 1) {
            AbstractStatementWrapper wrapper = batchType == BatchStatement.Type.LOGGED ? new BatchStatementWrapper(batchType, statementWrappers, (Optional<info.archinnov.achilles.type.ConsistencyLevel>)Optional.fromNullable((Object)this.consistencyLevel), this.serialConsistencyLevel) : statementWrappers.get(0);
            resultSetFuture = this.daoContext.execute(wrapper);
        }
        return resultSetFuture;
    }

    public void pushStatement(AbstractStatementWrapper statementWrapper) {
        this.statementWrappers.add(statementWrapper);
    }

    public void pushCounterStatement(AbstractStatementWrapper statementWrapper) {
        this.counterStatementWrappers.add(statementWrapper);
    }

    public ListenableFuture<ResultSet> execute(AbstractStatementWrapper statementWrapper) {
        return this.daoContext.execute(statementWrapper);
    }

    public void setConsistencyLevel(info.archinnov.achilles.type.ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public info.archinnov.achilles.type.ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public abstract void startBatch();

    public abstract ListenableFuture<List<ResultSet>> flush();

    public abstract ListenableFuture<Empty> flushBatch();

    public abstract FlushType type();

    public abstract AbstractFlushContext duplicate();

    public abstract void triggerInterceptor(EntityMeta var1, Object var2, Event var3);

    public String toString() {
        return this.type().toString();
    }

    public static enum FlushType {
        BATCH,
        IMMEDIATE;

    }
}

