/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.context;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ResultSet;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.async.EmptyFutureResultSets;
import info.archinnov.achilles.internal.context.AbstractFlushContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.interceptor.EventHolder;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Empty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchingFlushContext
extends AbstractFlushContext {
    private static final Logger log = LoggerFactory.getLogger(BatchingFlushContext.class);
    protected List<EventHolder> eventHolders = new ArrayList<EventHolder>();

    public BatchingFlushContext(DaoContext daoContext, ConsistencyLevel consistencyLevel, Optional<com.datastax.driver.core.ConsistencyLevel> serialConsistencyLevel) {
        super(daoContext, consistencyLevel, serialConsistencyLevel);
    }

    private BatchingFlushContext(DaoContext daoContext, List<AbstractStatementWrapper> statementWrappers, ConsistencyLevel consistencyLevel, Optional<com.datastax.driver.core.ConsistencyLevel> serialConsistencyLevel) {
        super(daoContext, statementWrappers, consistencyLevel, serialConsistencyLevel);
    }

    @Override
    public void startBatch() {
        log.debug("Starting a new batch");
    }

    @Override
    public ListenableFuture<List<ResultSet>> flush() {
        log.debug("Flush called but do nothing. Flushing is done only at the end of the batch");
        return new EmptyFutureResultSets();
    }

    public AchillesFuture<Empty> flushBatch() {
        log.debug("Ending current batch");
        Function<List<ResultSet>, Empty> applyTriggers = new Function<List<ResultSet>, Empty>(){

            public Empty apply(List<ResultSet> input) {
                for (EventHolder eventHolder : BatchingFlushContext.this.eventHolders) {
                    eventHolder.triggerInterception();
                }
                return Empty.INSTANCE;
            }
        };
        ListenableFuture<ResultSet> resultSetFutureFields = this.executeBatch(BatchStatement.Type.LOGGED, this.statementWrappers);
        ListenableFuture<ResultSet> resultSetFutureCounters = this.executeBatch(BatchStatement.Type.COUNTER, this.counterStatementWrappers);
        ImmutableList resultSetFutures = FluentIterable.from(Arrays.asList(resultSetFutureFields, resultSetFutureCounters)).filter(Predicates.not((Predicate)Predicates.isNull())).toList();
        ListenableFuture<List<ResultSet>> futureAsList = this.asyncUtils.mergeResultSetFutures((List<ListenableFuture<ResultSet>>)resultSetFutures);
        ListenableFuture<Empty> triggersApplied = this.asyncUtils.transformFuture(futureAsList, applyTriggers, this.daoContext.getExecutorService());
        return this.asyncUtils.buildInterruptible(triggersApplied);
    }

    @Override
    public AbstractFlushContext.FlushType type() {
        return AbstractFlushContext.FlushType.BATCH;
    }

    @Override
    public BatchingFlushContext duplicate() {
        return new BatchingFlushContext(this.daoContext, this.statementWrappers, this.consistencyLevel, (Optional<com.datastax.driver.core.ConsistencyLevel>)this.serialConsistencyLevel);
    }

    @Override
    public void triggerInterceptor(EntityMeta meta, Object entity, Event event) {
        if (event == Event.POST_LOAD) {
            meta.forInterception().intercept(entity, Event.POST_LOAD);
        } else {
            this.eventHolders.add(new EventHolder(meta, entity, event));
        }
    }

    public BatchingFlushContext duplicateWithNoData(ConsistencyLevel defaultConsistencyLevel) {
        return new BatchingFlushContext(this.daoContext, new ArrayList<AbstractStatementWrapper>(), defaultConsistencyLevel, (Optional<com.datastax.driver.core.ConsistencyLevel>)this.serialConsistencyLevel);
    }

    public BatchingFlushContext duplicateWithNoData(ConsistencyLevel defaultConsistencyLevel, Optional<com.datastax.driver.core.ConsistencyLevel> serialConsistencyLevel) {
        return new BatchingFlushContext(this.daoContext, new ArrayList<AbstractStatementWrapper>(), defaultConsistencyLevel, serialConsistencyLevel);
    }

    public BatchingFlushContext duplicateWithNoData() {
        return new BatchingFlushContext(this.daoContext, new ArrayList<AbstractStatementWrapper>(), this.consistencyLevel, (Optional<com.datastax.driver.core.ConsistencyLevel>)this.serialConsistencyLevel);
    }
}

