/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.context;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.exception.AchillesStaleObjectStateException;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.async.AsyncUtils;
import info.archinnov.achilles.internal.async.ImmediateValue;
import info.archinnov.achilles.internal.consistency.ConsistencyOverrider;
import info.archinnov.achilles.internal.context.AbstractFlushContext;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.facade.DaoOperations;
import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.context.facade.PersistenceManagerOperations;
import info.archinnov.achilles.internal.context.facade.PersistentStateHolder;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityInitializer;
import info.archinnov.achilles.internal.persistence.operations.EntityLoader;
import info.archinnov.achilles.internal.persistence.operations.EntityPersister;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.persistence.operations.EntityRefresher;
import info.archinnov.achilles.internal.persistence.operations.EntityUpdater;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyCheckChangeSet;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.type.Empty;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.OptionsBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceContext {
    private static final Logger log = LoggerFactory.getLogger(PersistenceContext.class);
    protected AbstractFlushContext flushContext;
    protected EntityInitializer initializer = EntityInitializer.Singleton.INSTANCE.get();
    protected EntityPersister persister = EntityPersister.Singleton.INSTANCE.get();
    protected EntityProxifier proxifier = EntityProxifier.Singleton.INSTANCE.get();
    protected EntityRefresher refresher = EntityRefresher.Singleton.INSTANCE.get();
    protected EntityLoader loader = EntityLoader.Singleton.INSTANCE.get();
    protected EntityUpdater updater = EntityUpdater.Singleton.INSTANCE.get();
    protected ConfigurationContext configContext;
    protected Class<?> entityClass;
    protected EntityMeta entityMeta;
    protected Object entity;
    protected Object primaryKey;
    protected Object partitionKey;
    protected Options options = OptionsBuilder.noOptions();
    protected DaoContext daoContext;
    private ConsistencyOverrider overrider = ConsistencyOverrider.Singleton.INSTANCE.get();
    protected AsyncUtils asyncUtils = AsyncUtils.Singleton.INSTANCE.get();
    protected PersistenceManagerFacade persistenceManagerFacade = new PersistenceManagerFacade();
    protected EntityFacade entityFacade = new EntityFacade();
    protected DaoFacade daoFacade = new DaoFacade();
    protected StateHolderFacade stateHolderFacade = new StateHolderFacade();
    private Function<PropertyMeta, Method> metaToGetter = new Function<PropertyMeta, Method>(){

        public Method apply(PropertyMeta meta) {
            return meta.getGetter();
        }
    };

    public PersistenceContext(EntityMeta entityMeta, ConfigurationContext configContext, DaoContext daoContext, AbstractFlushContext flushContext, Class<?> entityClass, Object primaryKey, Options options) {
        Validator.validateNotNull(entityClass, "The entity class should not be null for persistence context creation", new Object[0]);
        Validator.validateNotNull(primaryKey, "The primary key for the entity class '{}' should not be null for persistence context creation", entityClass.getCanonicalName());
        this.entityMeta = entityMeta;
        this.configContext = configContext;
        this.daoContext = daoContext;
        this.flushContext = flushContext;
        this.entityClass = entityClass;
        this.primaryKey = primaryKey;
        this.options = this.overrider.overrideRuntimeValueByBatchSetting(options, flushContext);
    }

    public PersistenceContext(EntityMeta entityMeta, ConfigurationContext configContext, DaoContext daoContext, AbstractFlushContext flushContext, Object entity, Options options) {
        Validator.validateNotNull(entity, "The entity of type '{}' should not be null for persistence context creation", entityMeta.getClassName());
        this.primaryKey = entityMeta.forOperations().getPrimaryKey(entity);
        Validator.validateNotNull(this.primaryKey, "The primary key for the entity class '{}' should not be null for persistence context creation", entityMeta.getClassName());
        this.entityClass = entityMeta.getEntityClass();
        this.entityMeta = entityMeta;
        this.configContext = configContext;
        this.daoContext = daoContext;
        this.flushContext = flushContext;
        this.entity = entity;
        this.options = this.overrider.overrideRuntimeValueByBatchSetting(options, flushContext);
    }

    public PersistenceContext duplicate(Object entity) {
        log.trace("Duplicate PersistenceContext for entity '{}'", entity);
        return new PersistenceContext(this.entityMeta, this.configContext, this.daoContext, this.flushContext.duplicate(), entity, this.options.duplicateWithoutTtlAndTimestamp());
    }

    public StateHolderFacade getStateHolderFacade() {
        return this.stateHolderFacade;
    }

    public EntityFacade getEntityFacade() {
        return this.entityFacade;
    }

    public PersistenceManagerFacade getPersistenceManagerFacade() {
        return this.persistenceManagerFacade;
    }

    public String toString() {
        return Objects.toStringHelper(PersistenceContext.class).add("entity class", this.entityClass).add("primary key", this.primaryKey).add("partition key", this.partitionKey).toString();
    }

    public class DaoFacade
    extends StateHolderFacade
    implements DaoOperations {
        private DaoFacade() {
        }

        @Override
        public void pushStatement(AbstractStatementWrapper statementWrapper) {
            PersistenceContext.this.flushContext.pushStatement(statementWrapper);
        }

        @Override
        public void pushCounterStatement(AbstractStatementWrapper statementWrapper) {
            PersistenceContext.this.flushContext.pushCounterStatement(statementWrapper);
        }

        @Override
        public ListenableFuture<ResultSet> executeImmediate(AbstractStatementWrapper bsWrapper) {
            return PersistenceContext.this.flushContext.execute(bsWrapper);
        }
    }

    public class EntityFacade
    extends StateHolderFacade
    implements EntityOperations {
        private EntityFacade() {
        }

        @Override
        public ListenableFuture<Row> loadEntity() {
            return PersistenceContext.this.daoContext.loadEntity(PersistenceContext.this.daoFacade);
        }

        @Override
        public Row loadProperty(PropertyMeta pm) {
            return PersistenceContext.this.daoContext.loadProperty(PersistenceContext.this.daoFacade, pm);
        }

        @Override
        public void pushInsertStatement() {
            List<PropertyMeta> pms = PersistenceContext.this.entityMeta.forOperations().retrievePropertyMetasForInsert(PersistenceContext.this.entity);
            PersistenceContext.this.daoContext.pushInsertStatement(PersistenceContext.this.daoFacade, pms);
        }

        @Override
        public void pushUpdateStatement(List<PropertyMeta> pms) {
            PersistenceContext.this.daoContext.pushUpdateStatement(PersistenceContext.this.daoFacade, pms);
        }

        @Override
        public void pushCollectionAndMapUpdateStatements(DirtyCheckChangeSet changeSet) {
            PersistenceContext.this.daoContext.pushCollectionAndMapUpdateStatement(PersistenceContext.this.daoFacade, changeSet);
        }

        @Override
        public void bindForDeletion(String tableName) {
            PersistenceContext.this.daoContext.bindForDeletion(PersistenceContext.this.daoFacade, PersistenceContext.this.entityMeta, tableName);
        }

        @Override
        public void bindForSimpleCounterIncrement(PropertyMeta counterMeta, Long increment) {
            PersistenceContext.this.daoContext.bindForSimpleCounterIncrement(PersistenceContext.this.daoFacade, counterMeta, increment);
        }

        @Override
        public Long getSimpleCounter(PropertyMeta counterMeta, info.archinnov.achilles.type.ConsistencyLevel consistency) {
            log.trace("Get counter value for counterMeta '{}' with consistency level '{}'", (Object)counterMeta, (Object)consistency);
            return PersistenceContext.this.daoContext.getSimpleCounter(PersistenceContext.this.daoFacade, counterMeta, consistency);
        }

        @Override
        public void bindForSimpleCounterDeletion(PropertyMeta counterMeta) {
            PersistenceContext.this.daoContext.bindForSimpleCounterDelete(PersistenceContext.this.daoFacade, counterMeta);
        }

        @Override
        public void pushClusteredCounterIncrementStatement(PropertyMeta counterMeta, Long increment) {
            PersistenceContext.this.daoContext.pushClusteredCounterIncrementStatement(PersistenceContext.this.daoFacade, counterMeta, increment);
        }

        @Override
        public ListenableFuture<Row> getClusteredCounter() {
            log.trace("Get clustered counter value for entityMeta '{}'", (Object)PersistenceContext.this.entityMeta);
            return PersistenceContext.this.daoContext.getClusteredCounter(PersistenceContext.this.daoFacade);
        }

        @Override
        public Long getClusteredCounterColumn(PropertyMeta counterMeta) {
            log.trace("Get clustered counter value for counterMeta '{}'", (Object)counterMeta);
            return PersistenceContext.this.daoContext.getClusteredCounterColumn(PersistenceContext.this.daoFacade, counterMeta);
        }

        @Override
        public void bindForClusteredCounterDeletion() {
            PersistenceContext.this.daoContext.bindForClusteredCounterDelete(PersistenceContext.this.daoFacade);
        }
    }

    public class PersistenceManagerFacade
    extends StateHolderFacade
    implements PersistenceManagerOperations {
        private PersistenceManagerFacade() {
        }

        @Override
        public <T> AchillesFuture<T> persist(final T rawEntity) {
            PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, rawEntity, Event.PRE_INSERT);
            PersistenceContext.this.persister.persist(PersistenceContext.this.entityFacade);
            ListenableFuture<List<ResultSet>> resultSetFutures = this.flush();
            Function applyTriggers = new Function<List<ResultSet>, T>(){

                public T apply(List<ResultSet> input) {
                    PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, rawEntity, Event.POST_INSERT);
                    return rawEntity;
                }
            };
            Function createProxy = new Function<T, T>(){

                public T apply(T input) {
                    return PersistenceContext.this.proxifier.buildProxyWithAllFieldsLoadedExceptCounters(rawEntity, PersistenceContext.this.entityFacade);
                }
            };
            ListenableFuture triggersApplied = PersistenceContext.this.asyncUtils.transformFuture(resultSetFutures, applyTriggers, this.getExecutorService());
            PersistenceContext.this.asyncUtils.maybeAddAsyncListeners(triggersApplied, PersistenceContext.this.options, this.getExecutorService());
            ListenableFuture proxyCreated = PersistenceContext.this.asyncUtils.transformFuture(triggersApplied, createProxy, this.getExecutorService());
            return PersistenceContext.this.asyncUtils.buildInterruptible(proxyCreated);
        }

        @Override
        public <T> AchillesFuture<T> batchPersist(T rawEntity) {
            PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, rawEntity, Event.PRE_INSERT);
            PersistenceContext.this.persister.persist(PersistenceContext.this.entityFacade);
            this.flush();
            PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, rawEntity, Event.POST_INSERT);
            T proxy = PersistenceContext.this.proxifier.buildProxyWithAllFieldsLoadedExceptCounters(rawEntity, PersistenceContext.this.entityFacade);
            return PersistenceContext.this.asyncUtils.buildInterruptible(new ImmediateValue<T>(proxy));
        }

        @Override
        public <T> AchillesFuture<T> update(final T proxy) {
            PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, PersistenceContext.this.entity, Event.PRE_UPDATE);
            PersistenceContext.this.updater.update(PersistenceContext.this.entityFacade, proxy);
            ListenableFuture<List<ResultSet>> resultSetFutures = this.flush();
            Function applyTriggers = new Function<List<ResultSet>, T>(){

                public T apply(List<ResultSet> input) {
                    PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, PersistenceContext.this.entity, Event.POST_UPDATE);
                    return proxy;
                }
            };
            ListenableFuture triggersApplied = PersistenceContext.this.asyncUtils.transformFuture(resultSetFutures, applyTriggers, this.getExecutorService());
            PersistenceContext.this.asyncUtils.maybeAddAsyncListeners(triggersApplied, PersistenceContext.this.options, this.getExecutorService());
            return PersistenceContext.this.asyncUtils.buildInterruptible(triggersApplied);
        }

        @Override
        public <T> AchillesFuture<T> delete() {
            PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, PersistenceContext.this.entity, Event.PRE_DELETE);
            PersistenceContext.this.persister.delete(PersistenceContext.this.entityFacade);
            ListenableFuture<List<ResultSet>> resultSetFutures = this.flush();
            Function applyTriggers = new Function<List<ResultSet>, T>(){

                public T apply(List<ResultSet> input) {
                    PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, PersistenceContext.this.entity, Event.POST_DELETE);
                    return PersistenceContext.this.entity;
                }
            };
            ListenableFuture triggersApplied = PersistenceContext.this.asyncUtils.transformFuture(resultSetFutures, applyTriggers, this.getExecutorService());
            PersistenceContext.this.asyncUtils.maybeAddAsyncListeners(triggersApplied, PersistenceContext.this.options, this.getExecutorService());
            return PersistenceContext.this.asyncUtils.buildInterruptible(triggersApplied);
        }

        @Override
        public AchillesFuture<Empty> deleteById() {
            PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, PersistenceContext.this.entity, Event.PRE_DELETE);
            PersistenceContext.this.persister.delete(PersistenceContext.this.entityFacade);
            ListenableFuture<List<ResultSet>> resultSetFutures = this.flush();
            Function<List<ResultSet>, Empty> toEmpty = new Function<List<ResultSet>, Empty>(){

                public Empty apply(List<ResultSet> input) {
                    return Empty.INSTANCE;
                }
            };
            ListenableFuture<Empty> triggersApplied = PersistenceContext.this.asyncUtils.transformFuture(resultSetFutures, toEmpty, this.getExecutorService());
            PersistenceContext.this.asyncUtils.maybeAddAsyncListeners(triggersApplied, PersistenceContext.this.options, this.getExecutorService());
            return PersistenceContext.this.asyncUtils.buildInterruptible(triggersApplied);
        }

        @Override
        public <T> AchillesFuture<T> find(Class<T> entityClass) {
            AchillesFuture<T> achillesFuture = PersistenceContext.this.loader.load(PersistenceContext.this.entityFacade, entityClass);
            Function applyTrigger = new Function<T, T>(){

                public T apply(T rawEntity) {
                    if (rawEntity != null) {
                        PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, rawEntity, Event.POST_LOAD);
                    }
                    return rawEntity;
                }
            };
            ListenableFuture triggersApplied = PersistenceContext.this.asyncUtils.transformFuture(achillesFuture, applyTrigger, this.getExecutorService());
            PersistenceContext.this.asyncUtils.maybeAddAsyncListeners(triggersApplied, PersistenceContext.this.options, this.getExecutorService());
            Function createProxy = new Function<T, T>(){

                public T apply(T rawEntity) {
                    return PersistenceContext.this.proxifier.buildProxyWithAllFieldsLoadedExceptCounters(rawEntity, PersistenceContext.this.entityFacade);
                }
            };
            ListenableFuture proxyCreated = PersistenceContext.this.asyncUtils.transformFuture(triggersApplied, createProxy, this.getExecutorService());
            return PersistenceContext.this.asyncUtils.buildInterruptible(proxyCreated);
        }

        @Override
        public <T> AchillesFuture<T> getProxy(Class<T> entityClass) {
            T entity = PersistenceContext.this.loader.createEmptyEntity(PersistenceContext.this.entityFacade, entityClass);
            T proxy = PersistenceContext.this.proxifier.buildProxyWithNoFieldLoaded(entity, PersistenceContext.this.entityFacade);
            ImmediateValue<T> immediateValue = new ImmediateValue<T>(proxy);
            PersistenceContext.this.asyncUtils.maybeAddAsyncListeners(immediateValue, PersistenceContext.this.options, this.getExecutorService());
            return PersistenceContext.this.asyncUtils.buildInterruptible(immediateValue);
        }

        @Override
        public <T> AchillesFuture<T> refresh(T proxy) throws AchillesStaleObjectStateException {
            AchillesFuture<T> achillesFuture = PersistenceContext.this.refresher.refresh(proxy, PersistenceContext.this.entityFacade);
            Function removeProxy = new Function<T, T>(){

                public T apply(T proxy) {
                    return PersistenceContext.this.proxifier.removeProxy(proxy);
                }
            };
            ListenableFuture proxyRemoved = PersistenceContext.this.asyncUtils.transformFuture(achillesFuture, removeProxy, this.getExecutorService());
            PersistenceContext.this.asyncUtils.maybeAddAsyncListeners(proxyRemoved, PersistenceContext.this.options, this.getExecutorService());
            Function applyTriggers = new Function<T, T>(){

                public T apply(T refreshedEntity) {
                    PersistenceContext.this.flushContext.triggerInterceptor(PersistenceContext.this.entityMeta, PersistenceContext.this.entity, Event.POST_LOAD);
                    return refreshedEntity;
                }
            };
            ListenableFuture triggersApplied = PersistenceContext.this.asyncUtils.transformFuture(achillesFuture, applyTriggers, this.getExecutorService());
            return PersistenceContext.this.asyncUtils.buildInterruptible(triggersApplied);
        }

        @Override
        public <T> T initialize(T proxy) {
            PersistenceContext.this.initializer.initializeEntity(proxy, PersistenceContext.this.entityMeta);
            return proxy;
        }

        @Override
        public <T> List<T> initialize(List<T> entities) {
            for (T entity : entities) {
                this.initialize(entity);
            }
            return entities;
        }

        @Override
        public <T> Set<T> initialize(Set<T> entities) {
            for (T entity : entities) {
                this.initialize(entity);
            }
            return entities;
        }

        protected ListenableFuture<List<ResultSet>> flush() {
            return PersistenceContext.this.flushContext.flush();
        }
    }

    public class StateHolderFacade
    implements PersistentStateHolder {
        private StateHolderFacade() {
        }

        @Override
        public PropertyMeta getIdMeta() {
            return PersistenceContext.this.entityMeta.getIdMeta();
        }

        @Override
        public boolean isClusteredCounter() {
            return PersistenceContext.this.entityMeta.structure().isClusteredCounter();
        }

        @Override
        public EntityMeta getEntityMeta() {
            return PersistenceContext.this.entityMeta;
        }

        @Override
        public Object getEntity() {
            return PersistenceContext.this.entity;
        }

        @Override
        public void setEntity(Object entity) {
            PersistenceContext.this.entity = entity;
        }

        @Override
        public <T> Class<T> getEntityClass() {
            return PersistenceContext.this.entityClass;
        }

        @Override
        public Object getPrimaryKey() {
            return PersistenceContext.this.primaryKey;
        }

        @Override
        public Options getOptions() {
            return PersistenceContext.this.options;
        }

        @Override
        public Optional<Integer> getTtl() {
            return PersistenceContext.this.options.getTtl();
        }

        @Override
        public Optional<Long> getTimestamp() {
            return PersistenceContext.this.options.getTimestamp();
        }

        @Override
        public Optional<info.archinnov.achilles.type.ConsistencyLevel> getConsistencyLevel() {
            return PersistenceContext.this.options.getConsistencyLevel();
        }

        @Override
        public Optional<ConsistencyLevel> getSerialConsistencyLevel() {
            return PersistenceContext.this.options.getSerialConsistency();
        }

        @Override
        public List<Options.CASCondition> getCasConditions() {
            return (List)Optional.fromNullable(PersistenceContext.this.options.getCASConditions()).or(new ArrayList());
        }

        @Override
        public boolean hasCasConditions() {
            return PersistenceContext.this.options.hasCASConditions();
        }

        @Override
        public Optional getCASResultListener() {
            return PersistenceContext.this.options.getCasResultListener();
        }

        @Override
        public Set<Method> getAllGettersExceptCounters() {
            return new HashSet<Method>((Collection<Method>)FluentIterable.from(PersistenceContext.this.entityMeta.getAllMetasExceptCounters()).transform(PersistenceContext.this.metaToGetter).toList());
        }

        @Override
        public List<PropertyMeta> getAllCountersMeta() {
            return PersistenceContext.this.entityMeta.getAllCounterMetas();
        }

        @Override
        public ConfigurationContext getConfigContext() {
            return PersistenceContext.this.configContext;
        }

        @Override
        public ExecutorService getExecutorService() {
            return PersistenceContext.this.configContext.getExecutorService();
        }
    }
}

