/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.cql;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.metadata.holder.InternalTimeUUID;
import info.archinnov.achilles.internal.metadata.parsing.PropertyParser;
import info.archinnov.achilles.type.Counter;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class TypeMapper {
    private static final Map<Class<?>, DataType.Name> java2CQL = new HashMap();
    private static final Map<Class<?>, DataType> java2CQLDataType = new HashMap();
    private static final Map<DataType.Name, Class<?>> cql2Java = new HashMap();
    private static final Map<Class<?>, Method> rowPropertyInvoker = new HashMap();

    public static DataType.Name toCQLType(Class<?> javaType) {
        DataType.Name name = java2CQL.get(javaType);
        if (name == null) {
            name = DataType.Name.TEXT;
        }
        return name;
    }

    public static DataType toCQLDataType(Class<?> javaType) {
        DataType dataType = java2CQLDataType.get(javaType);
        if (dataType == null) {
            dataType = DataType.text();
        }
        return dataType;
    }

    public static Class<?> toJavaType(DataType.Name cqlType) {
        return cql2Java.get(cqlType);
    }

    public static Method getRowMethod(Class<?> javaType) {
        Method method = rowPropertyInvoker.get(javaType);
        if (method == null) {
            method = rowPropertyInvoker.get(String.class);
        }
        return method;
    }

    public static Class<?> toCompatibleJavaType(Class<?> originalClass) {
        if (PropertyParser.isSupportedNativeType(originalClass)) {
            return originalClass;
        }
        return String.class;
    }

    static {
        java2CQL.put(Byte.TYPE, DataType.Name.BLOB);
        java2CQL.put(Byte.class, DataType.Name.BLOB);
        java2CQL.put(byte[].class, DataType.Name.BLOB);
        java2CQL.put(ByteBuffer.class, DataType.Name.BLOB);
        java2CQLDataType.put(Byte.TYPE, DataType.blob());
        java2CQLDataType.put(Byte.class, DataType.blob());
        java2CQLDataType.put(byte[].class, DataType.blob());
        java2CQLDataType.put(ByteBuffer.class, DataType.blob());
        java2CQL.put(Boolean.class, DataType.Name.BOOLEAN);
        java2CQL.put(Boolean.TYPE, DataType.Name.BOOLEAN);
        java2CQLDataType.put(Boolean.class, DataType.cboolean());
        java2CQLDataType.put(Boolean.TYPE, DataType.cboolean());
        java2CQL.put(Date.class, DataType.Name.TIMESTAMP);
        java2CQL.put(InternalTimeUUID.class, DataType.Name.TIMEUUID);
        java2CQLDataType.put(Date.class, DataType.timestamp());
        java2CQLDataType.put(InternalTimeUUID.class, DataType.timeuuid());
        java2CQL.put(Double.class, DataType.Name.DOUBLE);
        java2CQL.put(Double.TYPE, DataType.Name.DOUBLE);
        java2CQLDataType.put(Double.class, DataType.cdouble());
        java2CQLDataType.put(Double.TYPE, DataType.cdouble());
        java2CQL.put(Float.class, DataType.Name.FLOAT);
        java2CQL.put(Float.TYPE, DataType.Name.FLOAT);
        java2CQL.put(BigDecimal.class, DataType.Name.DECIMAL);
        java2CQLDataType.put(Float.class, DataType.cfloat());
        java2CQLDataType.put(Float.TYPE, DataType.cfloat());
        java2CQLDataType.put(BigDecimal.class, DataType.decimal());
        java2CQL.put(InetAddress.class, DataType.Name.INET);
        java2CQLDataType.put(InetAddress.class, DataType.inet());
        java2CQL.put(BigInteger.class, DataType.Name.VARINT);
        java2CQL.put(Integer.class, DataType.Name.INT);
        java2CQL.put(Integer.TYPE, DataType.Name.INT);
        java2CQLDataType.put(BigInteger.class, DataType.varint());
        java2CQLDataType.put(Integer.class, DataType.cint());
        java2CQLDataType.put(Integer.TYPE, DataType.cint());
        java2CQL.put(Long.class, DataType.Name.BIGINT);
        java2CQL.put(Long.TYPE, DataType.Name.BIGINT);
        java2CQLDataType.put(Long.class, DataType.bigint());
        java2CQLDataType.put(Long.TYPE, DataType.bigint());
        java2CQL.put(String.class, DataType.Name.TEXT);
        java2CQLDataType.put(String.class, DataType.text());
        java2CQL.put(UUID.class, DataType.Name.UUID);
        java2CQLDataType.put(UUID.class, DataType.uuid());
        java2CQL.put(List.class, DataType.Name.LIST);
        java2CQL.put(Set.class, DataType.Name.SET);
        java2CQL.put(Map.class, DataType.Name.MAP);
        java2CQL.put(Counter.class, DataType.Name.COUNTER);
        java2CQLDataType.put(Counter.class, DataType.counter());
        cql2Java.put(DataType.Name.ASCII, String.class);
        cql2Java.put(DataType.Name.BIGINT, Long.class);
        cql2Java.put(DataType.Name.BLOB, ByteBuffer.class);
        cql2Java.put(DataType.Name.BOOLEAN, Boolean.class);
        cql2Java.put(DataType.Name.COUNTER, Long.class);
        cql2Java.put(DataType.Name.DECIMAL, BigDecimal.class);
        cql2Java.put(DataType.Name.DOUBLE, Double.class);
        cql2Java.put(DataType.Name.FLOAT, Float.class);
        cql2Java.put(DataType.Name.INET, InetAddress.class);
        cql2Java.put(DataType.Name.INT, Integer.class);
        cql2Java.put(DataType.Name.TEXT, String.class);
        cql2Java.put(DataType.Name.TIMESTAMP, Date.class);
        cql2Java.put(DataType.Name.UUID, UUID.class);
        cql2Java.put(DataType.Name.VARCHAR, String.class);
        cql2Java.put(DataType.Name.VARINT, BigInteger.class);
        cql2Java.put(DataType.Name.TIMEUUID, UUID.class);
        cql2Java.put(DataType.Name.LIST, List.class);
        cql2Java.put(DataType.Name.SET, Set.class);
        cql2Java.put(DataType.Name.MAP, Map.class);
        cql2Java.put(DataType.Name.CUSTOM, ByteBuffer.class);
        try {
            rowPropertyInvoker.put(Byte.TYPE, Row.class.getDeclaredMethod("getBytes", String.class));
            rowPropertyInvoker.put(Byte.class, Row.class.getDeclaredMethod("getBytes", String.class));
            rowPropertyInvoker.put(byte[].class, Row.class.getDeclaredMethod("getBytes", String.class));
            rowPropertyInvoker.put(ByteBuffer.class, Row.class.getDeclaredMethod("getBytes", String.class));
            rowPropertyInvoker.put(Boolean.class, Row.class.getDeclaredMethod("getBool", String.class));
            rowPropertyInvoker.put(Boolean.TYPE, Row.class.getDeclaredMethod("getBool", String.class));
            rowPropertyInvoker.put(Date.class, Row.class.getDeclaredMethod("getDate", String.class));
            rowPropertyInvoker.put(Double.class, Row.class.getDeclaredMethod("getDouble", String.class));
            rowPropertyInvoker.put(Double.TYPE, Row.class.getDeclaredMethod("getDouble", String.class));
            rowPropertyInvoker.put(Float.class, Row.class.getDeclaredMethod("getFloat", String.class));
            rowPropertyInvoker.put(Float.TYPE, Row.class.getDeclaredMethod("getFloat", String.class));
            rowPropertyInvoker.put(BigDecimal.class, Row.class.getDeclaredMethod("getDecimal", String.class));
            rowPropertyInvoker.put(InetAddress.class, Row.class.getDeclaredMethod("getInet", String.class));
            rowPropertyInvoker.put(BigInteger.class, Row.class.getDeclaredMethod("getVarint", String.class));
            rowPropertyInvoker.put(Integer.class, Row.class.getDeclaredMethod("getInt", String.class));
            rowPropertyInvoker.put(Integer.TYPE, Row.class.getDeclaredMethod("getInt", String.class));
            rowPropertyInvoker.put(Long.class, Row.class.getDeclaredMethod("getLong", String.class));
            rowPropertyInvoker.put(Long.TYPE, Row.class.getDeclaredMethod("getLong", String.class));
            rowPropertyInvoker.put(String.class, Row.class.getDeclaredMethod("getString", String.class));
            rowPropertyInvoker.put(UUID.class, Row.class.getDeclaredMethod("getUUID", String.class));
            rowPropertyInvoker.put(InternalTimeUUID.class, Row.class.getDeclaredMethod("getUUID", String.class));
        }
        catch (Exception e) {
            throw new AchillesException("Cannot find getter in '" + Row.class.getCanonicalName() + "' ", (Throwable)e);
        }
    }
}

