/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.interceptor;

import info.archinnov.achilles.exception.AchillesBeanValidationException;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.interceptor.Interceptor;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validator;
import org.apache.commons.lang3.StringUtils;

public class DefaultBeanValidationInterceptor
implements Interceptor<Object> {
    private Validator validator;

    public DefaultBeanValidationInterceptor(Validator validator) {
        this.validator = validator;
    }

    public void onEvent(Object entity) {
        Set violations = this.validator.validate(entity, new Class[0]);
        if (violations.size() > 0) {
            StringBuilder errorMessage = new StringBuilder("Bean validation error : \n");
            for (ConstraintViolation violation : violations) {
                this.buildValidationErrorMessage(errorMessage, (ConstraintViolation<Object>)violation);
            }
            throw new AchillesBeanValidationException(errorMessage.toString());
        }
    }

    private void buildValidationErrorMessage(StringBuilder errorMessage, ConstraintViolation<Object> violation) {
        String className = violation.getLeafBean().getClass().getCanonicalName();
        Path propertyPath = violation.getPropertyPath();
        errorMessage.append("\t");
        if (propertyPath != null && StringUtils.isNotBlank((CharSequence)propertyPath.toString())) {
            errorMessage.append("property '").append(propertyPath).append("'").append(" of class '").append(className).append("' ").append(violation.getMessage()).append("\n");
        } else {
            errorMessage.append(violation.getMessage()).append(" for class '").append(className).append("'");
        }
    }

    public List<Event> events() {
        return Arrays.asList(Event.PRE_INSERT, Event.PRE_UPDATE);
    }
}

