/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.discovery;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import info.archinnov.achilles.interceptor.Interceptor;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.DaoContextFactory;
import info.archinnov.achilles.internal.context.SchemaContext;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.EntityMetaConfig;
import info.archinnov.achilles.internal.metadata.parsing.EntityParser;
import info.archinnov.achilles.internal.metadata.parsing.PropertyParser;
import info.archinnov.achilles.internal.metadata.parsing.context.EntityParsingContext;
import info.archinnov.achilles.internal.metadata.parsing.context.ParsingResult;
import info.archinnov.achilles.internal.validation.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AchillesBootstrapper {
    private static final Logger log = LoggerFactory.getLogger(AchillesBootstrapper.class);
    private EntityParser entityParser = EntityParser.Singleton.INSTANCE.get();
    private PropertyParser propertyParser = PropertyParser.Singleton.INSTANCE.get();
    private DaoContextFactory daoContextFactory = new DaoContextFactory();

    public ParsingResult buildMetaDatas(ConfigurationContext configContext, List<Class<?>> entities) {
        log.debug("Build meta data for candidate entities");
        HashMap entityMetaMap = new HashMap();
        boolean hasSimpleCounter = false;
        for (Class<?> entityClass : entities) {
            EntityParsingContext context = new EntityParsingContext(configContext, entityClass);
            EntityMeta entityMeta = this.entityParser.parseEntity(context);
            entityMetaMap.put(entityClass, entityMeta);
            boolean bl = hasSimpleCounter = hasSimpleCounter || context.hasSimpleCounter() != false && !entityMeta.structure().isClusteredCounter();
            boolean shouldValidateBean = configContext.isClassConstrained(entityClass);
            if (!shouldValidateBean) continue;
            configContext.addBeanValidationInterceptor(entityMeta);
        }
        return new ParsingResult(entityMetaMap, hasSimpleCounter);
    }

    public void validateOrCreateTables(SchemaContext schemaContext) {
        log.debug("Start schema validation/creation");
        Map<String, TableMetadata> tableMetaDatas = schemaContext.fetchTableMetaData();
        for (Map.Entry<Class<?>, EntityMeta> entry : schemaContext.entityMetaEntrySet()) {
            EntityMeta entityMeta = entry.getValue();
            EntityMetaConfig metaConfig = entityMeta.config();
            String qualifiedTableName = metaConfig.getQualifiedTableName().toLowerCase();
            if (tableMetaDatas.containsKey(qualifiedTableName)) {
                TableMetadata tableMetaData = tableMetaDatas.get(qualifiedTableName);
                schemaContext.validateForEntity(entityMeta, tableMetaData);
                schemaContext.updateForEntity(entityMeta, tableMetaData);
                continue;
            }
            schemaContext.createTableForEntity(entry.getValue());
        }
        if (schemaContext.hasSimpleCounter()) {
            if (tableMetaDatas.containsKey("achilles_counter_table")) {
                schemaContext.validateAchillesCounter();
            } else {
                schemaContext.createTableForCounter();
            }
        }
    }

    public DaoContext buildDaoContext(Session session, ParsingResult parsingResult, ConfigurationContext configContext) {
        log.debug("Build DaoContext");
        return this.daoContextFactory.create(session, parsingResult, configContext);
    }

    public void addInterceptorsToEntityMetas(List<Interceptor<?>> interceptors, Map<Class<?>, EntityMeta> entityMetaMap) {
        for (Interceptor<?> interceptor : interceptors) {
            Class<?> entityClass = this.propertyParser.inferEntityClassFromInterceptor(interceptor);
            EntityMeta entityMeta = entityMetaMap.get(entityClass);
            Validator.validateBeanMappingTrue(entityMeta != null, "The entity class '%s' is not found", entityClass.getCanonicalName());
            entityMeta.forInterception().addInterceptor(interceptor);
        }
    }
}

