/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.FluentIterable;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;

public abstract class AbstractComponentProperties {
    private static final Function<PropertyMeta, Class<?>> GET_CLASS = new Function<PropertyMeta, Class<?>>(){

        public Class<?> apply(PropertyMeta meta) {
            return meta.getValueClass();
        }
    };
    private static final Function<PropertyMeta, String> GET_NAME = new Function<PropertyMeta, String>(){

        public String apply(PropertyMeta meta) {
            return meta.getPropertyName();
        }
    };
    private static final Function<PropertyMeta, String> GET_CQL3_NAME = new Function<PropertyMeta, String>(){

        public String apply(PropertyMeta meta) {
            return meta.getCQL3ColumnName();
        }
    };
    private static final Function<PropertyMeta, Field> GET_FIELD = new Function<PropertyMeta, Field>(){

        public Field apply(PropertyMeta meta) {
            return meta.getField();
        }
    };
    protected final List<PropertyMeta> propertyMetas;

    protected AbstractComponentProperties(List<PropertyMeta> propertyMetas) {
        this.propertyMetas = propertyMetas;
    }

    public List<Class<?>> getComponentClasses() {
        return FluentIterable.from(this.propertyMetas).transform(GET_CLASS).toList();
    }

    public List<Class<?>> getCQL3ComponentClasses() {
        return FluentIterable.from(this.propertyMetas).transform(GET_CLASS).toList();
    }

    public List<Field> getComponentFields() {
        return FluentIterable.from(this.propertyMetas).transform(GET_FIELD).toList();
    }

    public List<String> getComponentNames() {
        return FluentIterable.from(this.propertyMetas).transform(GET_NAME).toList();
    }

    public List<String> getCQL3ComponentNames() {
        return FluentIterable.from(this.propertyMetas).transform(GET_CQL3_NAME).toList();
    }

    protected static boolean isCompatibleClass(Class<?> expected, Class<?> given) {
        return (expected = ClassUtils.primitiveToWrapper(expected)) == given || expected.isAssignableFrom(given);
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("propertyMetas", this.propertyMetas).toString();
    }
}

