/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.EntityMetaView;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.type.IndexCondition;
import info.archinnov.achilles.type.Options;
import java.util.List;

public class EntityMetaTranscoder
extends EntityMetaView {
    protected EntityMetaTranscoder(EntityMeta meta) {
        super(meta);
    }

    public Object encodeCasConditionValue(Options.CASCondition CASCondition2) {
        Object rawValue = CASCondition2.getValue();
        String columnName = CASCondition2.getColumnName();
        Object encodedValue = this.encodeValueForProperty(columnName, rawValue);
        CASCondition2.encodedValue(encodedValue);
        return encodedValue;
    }

    public Object encodeIndexConditionValue(IndexCondition indexCondition) {
        Object rawValue = indexCondition.getColumnValue();
        String columnName = indexCondition.getColumnName();
        Object encodedValue = this.encodeValueForProperty(columnName, rawValue);
        indexCondition.encodedValue(encodedValue);
        return encodedValue;
    }

    public List<Object> encodePartitionComponents(List<Object> rawPartitionComponents) {
        return this.meta.getIdMeta().forTranscoding().encodePartitionComponents(rawPartitionComponents);
    }

    public List<Object> encodePartitionComponentsIN(List<Object> rawPartitionComponentsIN) {
        return this.meta.getIdMeta().forTranscoding().encodePartitionComponentsIN(rawPartitionComponentsIN);
    }

    public List<Object> encodeClusteringKeys(List<Object> rawClusteringKeys) {
        return this.meta.getIdMeta().forTranscoding().encodeClusteringKeys(rawClusteringKeys);
    }

    public List<Object> encodeClusteringKeysIN(List<Object> rawClusteringKeysIN) {
        return this.meta.getIdMeta().forTranscoding().encodeClusteringKeysIN(rawClusteringKeysIN);
    }

    private Object encodeValueForProperty(String columnName, Object rawValue) {
        Object encodedValue = rawValue;
        if (rawValue != null) {
            PropertyMeta propertyMeta = this.findPropertyMetaByCQL3Name(columnName);
            encodedValue = propertyMeta.forTranscoding().encodeToCassandra(rawValue);
        }
        return encodedValue;
    }

    private PropertyMeta findPropertyMetaByCQL3Name(String cql3Name) {
        for (PropertyMeta propertyMeta : this.meta.getAllMetasExceptCounters()) {
            if (!propertyMeta.getCQL3ColumnName().equals(cql3Name)) continue;
            return propertyMeta;
        }
        throw new AchillesException(String.format("Cannot find matching property meta for the cql3 field %s", cql3Name));
    }
}

