/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import info.archinnov.achilles.codec.Codec;
import info.archinnov.achilles.internal.metadata.codec.ListCodec;
import info.archinnov.achilles.internal.metadata.codec.MapCodec;
import info.archinnov.achilles.internal.metadata.codec.SetCodec;
import info.archinnov.achilles.internal.metadata.holder.CounterProperties;
import info.archinnov.achilles.internal.metadata.holder.EmbeddedIdProperties;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyType;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMetaBuilder {
    private static final Logger log = LoggerFactory.getLogger(PropertyMetaBuilder.class);
    private PropertyType type;
    private String propertyName;
    private String cql3ColumnName;
    private String entityClassName;
    private Method[] accessors;
    private Field field;
    private ObjectMapper objectMapper;
    private CounterProperties counterProperties;
    private EmbeddedIdProperties embeddedIdProperties;
    private Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels;
    private boolean timeUUID = false;
    private boolean emptyCollectionAndMapIfNull = false;
    private boolean staticColumn = false;
    private Codec simpleCodec;
    private ListCodec listCodec;
    private SetCodec setCodec;
    private MapCodec mapCodec;
    private Class<?> cql3KeyClass;
    private Class<?> cql3ValueClass;

    public static PropertyMetaBuilder factory() {
        return new PropertyMetaBuilder();
    }

    public PropertyMetaBuilder propertyName(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    public PropertyMetaBuilder cqlColumnName(String cqlColumnName) {
        this.cql3ColumnName = cqlColumnName;
        return this;
    }

    public PropertyMetaBuilder entityClassName(String entityClassName) {
        this.entityClassName = entityClassName;
        return this;
    }

    public PropertyMetaBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public PropertyMeta build(Class<?> keyClass, Class<?> valueClass) {
        log.debug("Build propertyMeta for property {} of entity class {}", (Object)this.propertyName, (Object)this.entityClassName);
        PropertyMeta meta = new PropertyMeta();
        meta.setField(this.field);
        meta.setType(this.type);
        meta.setPropertyName(this.propertyName);
        meta.setEntityClassName(this.entityClassName);
        meta.setKeyClass(keyClass);
        meta.setValueClass(valueClass);
        meta.setGetter(this.accessors[0]);
        meta.setSetter(this.accessors[1]);
        meta.setEmbeddedIdProperties(this.embeddedIdProperties);
        meta.setCounterProperties(this.counterProperties);
        meta.setConsistencyLevels(this.consistencyLevels);
        meta.setTimeUUID(this.timeUUID);
        meta.setEmptyCollectionAndMapIfNull(this.emptyCollectionAndMapIfNull);
        meta.setStaticColumn(this.staticColumn);
        meta.setSimpleCodec((Codec)Optional.fromNullable((Object)this.simpleCodec).orNull());
        meta.setListCodec((ListCodec)Optional.fromNullable((Object)this.listCodec).orNull());
        meta.setSetCodec((SetCodec)Optional.fromNullable((Object)this.setCodec).orNull());
        meta.setMapCodec((MapCodec)Optional.fromNullable((Object)this.mapCodec).orNull());
        meta.setCql3ColumnName(this.cql3ColumnName);
        meta.setCql3KeyClass(this.cql3KeyClass);
        meta.setCql3ValueClass(this.cql3ValueClass);
        return meta;
    }

    public PropertyMetaBuilder type(PropertyType type) {
        this.type = type;
        return this;
    }

    public PropertyMetaBuilder accessors(Method[] accessors) {
        this.accessors = accessors;
        return this;
    }

    public PropertyMetaBuilder field(Field field) {
        this.field = field;
        return this;
    }

    public PropertyMetaBuilder embeddedIdProperties(EmbeddedIdProperties embeddedIdProperties) {
        this.embeddedIdProperties = embeddedIdProperties;
        return this;
    }

    public PropertyMetaBuilder counterProperties(CounterProperties counterProperties) {
        this.counterProperties = counterProperties;
        return this;
    }

    public PropertyMetaBuilder consistencyLevels(Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels) {
        this.consistencyLevels = consistencyLevels;
        return this;
    }

    public PropertyMetaBuilder timeuuid(boolean timeUUID) {
        this.timeUUID = timeUUID;
        return this;
    }

    public PropertyMetaBuilder staticColumn(boolean staticColumn) {
        this.staticColumn = staticColumn;
        return this;
    }

    public PropertyMetaBuilder emptyCollectionAndMapIfNull(boolean emptyCollectionAndMapIfNull) {
        this.emptyCollectionAndMapIfNull = emptyCollectionAndMapIfNull;
        return this;
    }

    public PropertyMetaBuilder simpleCodec(Codec simpleCodec) {
        this.simpleCodec = simpleCodec;
        return this;
    }

    public PropertyMetaBuilder listCodec(ListCodec listCodec) {
        this.listCodec = listCodec;
        return this;
    }

    public PropertyMetaBuilder setCodec(SetCodec setCodec) {
        this.setCodec = setCodec;
        return this;
    }

    public PropertyMetaBuilder mapCodec(MapCodec mapCodec) {
        this.mapCodec = mapCodec;
        return this;
    }

    public PropertyMetaBuilder cql3KeyClass(Class<?> cql3KeyClass) {
        this.cql3KeyClass = cql3KeyClass;
        return this;
    }

    public PropertyMetaBuilder cql3ValueClass(Class<?> cql3ValueClass) {
        this.cql3ValueClass = cql3ValueClass;
        return this;
    }
}

