/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.datastax.driver.core.Row;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.cql.TypeMapper;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaView;
import info.archinnov.achilles.internal.validation.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMetaRowExtractor
extends PropertyMetaView {
    private static final Logger log = LoggerFactory.getLogger(PropertyMetaRowExtractor.class);

    protected PropertyMetaRowExtractor(PropertyMeta meta) {
        super(meta);
    }

    public List<Object> extractRawCompoundPrimaryComponentsFromRow(Row row) {
        log.trace("Extract raw compound primary components from CQL3 row {} for id meta {}", (Object)row, (Object)this.meta);
        Validator.validateNotNull(this.meta.getEmbeddedIdProperties(), "Cannot extract raw compound primary keys from CQL3 row because entity '%s' does not have a compound primary key", this.meta.getEntityClassName());
        List<Class<?>> componentClasses = this.meta.getEmbeddedIdProperties().getCQL3ComponentClasses();
        List<String> cql3ComponentNames = this.meta.getEmbeddedIdProperties().getCQL3ComponentNames();
        ArrayList<Object> rawValues = new ArrayList<Object>(Collections.nCopies(cql3ComponentNames.size(), null));
        try {
            for (int index = 0; index < cql3ComponentNames.size(); ++index) {
                Class<?> componentClass = componentClasses.get(index);
                Object rawValue = TypeMapper.getRowMethod(componentClass).invoke((Object)row, cql3ComponentNames.get(index));
                rawValues.set(index, rawValue);
            }
        }
        catch (Exception e) {
            throw new AchillesException(String.format("Cannot retrieve compound primary key for entity class '%s' from CQL Row", this.meta.getEntityClassName()), (Throwable)e);
        }
        return rawValues;
    }

    public void validateExtractedCompoundPrimaryComponents(List<Object> rawComponents) {
        log.trace("Validate raw compound primary components {} for id meta {}", rawComponents, (Object)this.meta);
        Validator.validateNotNull(this.meta.getEmbeddedIdProperties(), "Cannot validate raw compound primary keys from CQL3 row because entity '%s' does not have a compound primary key", this.meta.getEntityClassName());
        List<String> cql3ComponentNames = this.meta.getEmbeddedIdProperties().getCQL3ComponentNames();
        for (int i = 0; i < cql3ComponentNames.size(); ++i) {
            Validator.validateNotNull(rawComponents.get(i), "Error, the component '%s' from @EmbeddedId class '%s' cannot be found in Cassandra", cql3ComponentNames.get(i), this.meta.getValueClass());
        }
    }

    public Object invokeOnRowForFields(Row row) {
        if (log.isTraceEnabled()) {
            log.trace("Extract column {} from CQL3 row {} for id meta {}", new Object[]{this.meta.getCQL3ColumnName(), row, this.meta});
        }
        Object value = null;
        if (!row.isNull(this.meta.getCQL3ColumnName())) {
            switch (this.meta.type()) {
                case LIST: {
                    value = this.invokeOnRowForList(row);
                    break;
                }
                case SET: {
                    value = this.invokeOnRowForSet(row);
                    break;
                }
                case MAP: {
                    value = this.invokeOnRowForMap(row);
                    break;
                }
                case ID: 
                case SIMPLE: {
                    value = this.invokeOnRowForProperty(row);
                    break;
                }
            }
        } else {
            switch (this.meta.type()) {
                case LIST: 
                case SET: 
                case MAP: {
                    value = this.meta.forValues().nullValueForCollectionAndMap();
                    break;
                }
            }
        }
        return value;
    }

    public Object extractCompoundPrimaryKeyFromRow(Row row, EntityMeta entityMeta, EntityMeta.EntityState entityState) {
        log.trace("Extract compound primary key {} from CQL3 row for entity class {}", (Object)this.meta.getPropertyName(), (Object)this.meta.getEntityClassName());
        List<Object> rawComponents = this.extractRawCompoundPrimaryComponentsFromRow(row);
        if (entityState.isManaged() && !entityMeta.structure().hasOnlyStaticColumns()) {
            this.validateExtractedCompoundPrimaryComponents(rawComponents);
        }
        return this.meta.forTranscoding().decodeFromComponents(rawComponents);
    }

    private Object invokeOnRowForProperty(Row row) {
        String cql3ColumnName = this.meta.getCQL3ColumnName();
        String entityClassName = this.meta.getEntityClassName();
        log.trace("Extract property {} from CQL3 row for entity class {}", (Object)cql3ColumnName, (Object)entityClassName);
        try {
            Object rawValue = TypeMapper.getRowMethod(this.meta.getCql3ValueClass()).invoke((Object)row, cql3ColumnName);
            return this.meta.forTranscoding().decodeFromCassandra(rawValue);
        }
        catch (Exception e) {
            throw new AchillesException(String.format("Cannot retrieve property '%s' for entity class '%S' from CQL Row", cql3ColumnName, entityClassName), (Throwable)e);
        }
    }

    private Object invokeOnRowForList(Row row) {
        String cql3ColumnName = this.meta.getCQL3ColumnName();
        String entityClassName = this.meta.getEntityClassName();
        log.trace("Extract list property {} from CQL3 row for entity class {}", (Object)cql3ColumnName, (Object)entityClassName);
        try {
            List rawValues = row.getList(cql3ColumnName, TypeMapper.toCompatibleJavaType(this.meta.getCql3ValueClass()));
            return this.meta.forTranscoding().decodeFromCassandra(rawValues);
        }
        catch (Exception e) {
            throw new AchillesException(String.format("Cannot retrieve list property '%s' for entity class '%S' from CQL Row", cql3ColumnName, entityClassName), (Throwable)e);
        }
    }

    private Object invokeOnRowForSet(Row row) {
        String cql3ColumnName = this.meta.getCQL3ColumnName();
        String entityClassName = this.meta.getEntityClassName();
        log.trace("Extract set property {} from CQL3 row for entity class {}", (Object)cql3ColumnName, (Object)entityClassName);
        try {
            Set rawValues = row.getSet(cql3ColumnName, TypeMapper.toCompatibleJavaType(this.meta.getCql3ValueClass()));
            return this.meta.forTranscoding().decodeFromCassandra(rawValues);
        }
        catch (Exception e) {
            throw new AchillesException(String.format("Cannot retrieve set property '%s' for entity class '%S' from CQL Row", cql3ColumnName, entityClassName), (Throwable)e);
        }
    }

    private Object invokeOnRowForMap(Row row) {
        String cql3ColumnName = this.meta.getCQL3ColumnName();
        String entityClassName = this.meta.getEntityClassName();
        log.trace("Extract map property {} from CQL3 row for entity class {}", (Object)cql3ColumnName, (Object)entityClassName);
        try {
            Map rawValues = row.getMap(cql3ColumnName, TypeMapper.toCompatibleJavaType(this.meta.getCql3KeyClass()), TypeMapper.toCompatibleJavaType(this.meta.getCql3ValueClass()));
            return this.meta.forTranscoding().decodeFromCassandra(rawValues);
        }
        catch (Exception e) {
            throw new AchillesException(String.format("Cannot retrieve map property '%s' for entity class '%S' from CQL Row", cql3ColumnName, entityClassName), (Throwable)e);
        }
    }
}

