/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.google.common.collect.Iterables;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaView;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.schemabuilder.Create;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMetaSliceQuerySupport
extends PropertyMetaView {
    private static final Logger log = LoggerFactory.getLogger(PropertyMetaSliceQuerySupport.class);

    protected PropertyMetaSliceQuerySupport(PropertyMeta meta) {
        super(meta);
    }

    List<String> getPartitionKeysName(int size) {
        Validator.validateNotNull(this.meta.getEmbeddedIdProperties(), "Cannot get {} partition key names for entity '%s' because it does not have a compound primary key", size, this.meta.getEntityClassName());
        return this.meta.getEmbeddedIdProperties().getPartitionComponents().getCQL3ComponentNames().subList(0, size);
    }

    String getLastPartitionKeyName() {
        Validator.validateNotNull(this.meta.getEmbeddedIdProperties(), "Cannot get last partition key name for entity '%s' because it does not have a compound primary key", this.meta.getEntityClassName());
        return (String)Iterables.getLast(this.meta.getEmbeddedIdProperties().getPartitionComponents().getCQL3ComponentNames());
    }

    List<String> getClusteringKeysName(int size) {
        Validator.validateNotNull(this.meta.getEmbeddedIdProperties(), "Cannot get {} clustering key names for entity '%s' because it does not have a compound primary key", size, this.meta.getEntityClassName());
        return this.meta.getEmbeddedIdProperties().getClusteringComponents().getCQL3ComponentNames().subList(0, size);
    }

    String getLastClusteringKeyName() {
        Validator.validateNotNull(this.meta.getEmbeddedIdProperties(), "Cannot get last clustering key name for entity '%s' because it does not have a compound primary key", this.meta.getEntityClassName());
        return (String)Iterables.getLast(this.meta.getEmbeddedIdProperties().getClusteringComponents().getCQL3ComponentNames());
    }

    int getPartitionKeysSize() {
        return this.meta.getEmbeddedIdProperties().getPartitionComponents().propertyMetas.size();
    }

    int getClusteringKeysSize() {
        return this.meta.getEmbeddedIdProperties().getClusteringComponents().propertyMetas.size();
    }

    void validatePartitionComponents(Object ... partitionComponents) {
        log.trace("Validate partition key components {} for entity class {}", (Object)partitionComponents, (Object)this.meta.getEntityClassName());
        Validator.validateNotNull(this.meta.getEmbeddedIdProperties(), "Cannot validate partition components for entity '%s' because it does not have a compound primary key", this.meta.getEntityClassName());
        this.meta.getEmbeddedIdProperties().getPartitionComponents().validatePartitionComponents(this.meta.getEntityClassName(), partitionComponents);
    }

    void validatePartitionComponentsIn(Object ... partitionComponentsIN) {
        log.trace("Validate partition key components IN {} for entity class {}", (Object)partitionComponentsIN, (Object)this.meta.getEntityClassName());
        Validator.validateNotNull(this.meta.getEmbeddedIdProperties(), "Cannot validate partition components IN for entity '%s' because it does not have a compound primary key", this.meta.getEntityClassName());
        this.meta.getEmbeddedIdProperties().getPartitionComponents().validatePartitionComponentsIn(this.meta.getEntityClassName(), partitionComponentsIN);
    }

    void validateClusteringComponents(Object ... clusteringKeys) {
        log.trace("Validate clustering keys {} for entity class {}", (Object)clusteringKeys, (Object)this.meta.getEntityClassName());
        Validator.validateNotNull(this.meta.getEmbeddedIdProperties(), "Cannot validate clustering keys for entity '%s' because it does not have a compound primary key", this.meta.getEntityClassName());
        this.meta.getEmbeddedIdProperties().getClusteringComponents().validateClusteringComponents(this.meta.getEntityClassName(), clusteringKeys);
    }

    void validateClusteringComponentsIn(Object ... clusteringKeysIN) {
        log.trace("Validate clustering keys IN {} for entity class {}", (Object)clusteringKeysIN, (Object)this.meta.getEntityClassName());
        Validator.validateNotNull(this.meta.getEmbeddedIdProperties(), "Cannot validate clustering keys IN for entity '%s' because it does not have a compound primary key", this.meta.getEntityClassName());
        this.meta.getEmbeddedIdProperties().getClusteringComponents().validateClusteringComponentsIn(this.meta.getEntityClassName(), clusteringKeysIN);
    }

    public Create.Options.ClusteringOrder getClusteringOrder() {
        Validator.validateTrue(this.meta.structure().isClustered(), "Cannot get clustering order for entity {} because it is not clustered", this.meta.getEntityClassName());
        return this.meta.getEmbeddedIdProperties().getClusteringComponents().getClusteringOrders().get(0);
    }
}

