/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TableMetadata;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.cql.TypeMapper;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaView;
import info.archinnov.achilles.internal.table.ColumnMetaDataComparator;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.type.Counter;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMetaTableValidator
extends PropertyMetaView {
    private static final Logger log = LoggerFactory.getLogger(PropertyMetaTableValidator.class);
    private ColumnMetaDataComparator columnMetaDataComparator = ColumnMetaDataComparator.Singleton.INSTANCE.get();

    protected PropertyMetaTableValidator(PropertyMeta meta) {
        super(meta);
    }

    public void validatePrimaryKeyComponents(TableMetadata tableMetadata, boolean partitionKey) {
        log.debug("Validate existing primary key component from table {} against entity class {}", (Object)tableMetadata.getName(), (Object)this.meta.getEntityClassName());
        Validator.validateNotNull(this.meta.getEmbeddedIdProperties(), "Cannot validate compound primary keys components against Cassandra meta data because entity '%s' does not have a compound primary key", this.meta.getEntityClassName());
        if (partitionKey) {
            for (PropertyMeta partitionMeta : this.meta.getEmbeddedIdProperties().getPartitionComponents().propertyMetas) {
                this.validatePartitionComponent(tableMetadata, partitionMeta);
            }
        } else {
            for (PropertyMeta clusteringMeta : this.meta.getEmbeddedIdProperties().getClusteringComponents().propertyMetas) {
                this.validateClusteringComponent(tableMetadata, clusteringMeta);
            }
        }
    }

    public void validateColumn(TableMetadata tableMetaData, EntityMeta entityMeta, ConfigurationContext configContext) {
        String cql3ColumnName = this.meta.getCQL3ColumnName();
        Class columnJavaType = this.meta.config().getCQL3ValueType();
        boolean schemaUpdateEnabled = entityMeta.config().isSchemaUpdateEnabled();
        String tableName = tableMetaData.getName();
        if (log.isDebugEnabled()) {
            log.debug("Validate existing column {} from table {} against type {}", new Object[]{cql3ColumnName, tableName, columnJavaType});
        }
        ColumnMetadata columnMetadata = tableMetaData.getColumn(cql3ColumnName);
        if (schemaUpdateEnabled && columnMetadata == null) {
            return;
        }
        Validator.validateTableTrue(columnMetadata != null, "Cannot find column '%s' in the table '%s'", cql3ColumnName, tableName);
        this.validateColumnType(tableName, cql3ColumnName, columnMetadata, columnJavaType);
        this.validateStatic(cql3ColumnName, tableName, columnMetadata);
        if (!configContext.isRelaxIndexValidation()) {
            boolean columnIsIndexed = columnMetadata.getIndex() != null;
            Validator.validateTableFalse(columnIsIndexed ^ this.meta.structure().isIndexed(), "Column '%s' in the table '%s' is indexed (or not) whereas metadata indicates it is (or not)", cql3ColumnName, tableName);
        }
    }

    public void validateCollectionAndMapColumn(TableMetadata tableMetadata, EntityMeta entityMeta) {
        String cql3ColumnName = this.meta.getCQL3ColumnName();
        String tableName = tableMetadata.getName();
        boolean schemaUpdateEnabled = entityMeta.config().isSchemaUpdateEnabled();
        ColumnMetadata columnMetadata = tableMetadata.getColumn(cql3ColumnName);
        if (schemaUpdateEnabled && columnMetadata == null) {
            return;
        }
        Validator.validateTableTrue(columnMetadata != null, "Cannot find column '%s' in the table '%s'", cql3ColumnName, tableName);
        DataType.Name realType = columnMetadata.getType().getName();
        if (log.isDebugEnabled()) {
            log.debug("Validate existing collection/map column {} from table {} against type {}", new Object[]{cql3ColumnName, tableName, realType});
        }
        DataType.Name expectedValueType = TypeMapper.toCQLType(this.meta.config().getCQL3ValueType());
        switch (this.meta.type()) {
            case LIST: {
                Validator.validateTableTrue(realType == DataType.Name.LIST, "Column '%s' of table '%s' of type '%s' should be of type '%s' indeed", cql3ColumnName, tableName, realType, DataType.Name.LIST);
                DataType.Name realListValueType = ((DataType)columnMetadata.getType().getTypeArguments().get(0)).getName();
                Validator.validateTableTrue(realListValueType == expectedValueType, "Column '%s' of table '%s' of type 'List<%s>' should be of type 'List<%s>' indeed", cql3ColumnName, tableName, realListValueType, expectedValueType);
                break;
            }
            case SET: {
                Validator.validateTableTrue(realType == DataType.Name.SET, "Column '%s' of table '%s' of type '%s' should be of type '%s' indeed", cql3ColumnName, tableName, realType, DataType.Name.SET);
                DataType.Name realSetValueType = ((DataType)columnMetadata.getType().getTypeArguments().get(0)).getName();
                Validator.validateTableTrue(realSetValueType == expectedValueType, "Column '%s' of table '%s' of type 'Set<%s>' should be of type 'Set<%s>' indeed", cql3ColumnName, tableName, realSetValueType, expectedValueType);
                break;
            }
            case MAP: {
                Validator.validateTableTrue(realType == DataType.Name.MAP, "Column '%s' of table '%s' of type '%s' should be of type '%s' indeed", cql3ColumnName, tableName, realType, DataType.Name.MAP);
                DataType.Name expectedMapKeyType = TypeMapper.toCQLType(this.meta.config().getCQL3KeyType());
                DataType.Name realMapKeyType = ((DataType)columnMetadata.getType().getTypeArguments().get(0)).getName();
                DataType.Name realMapValueType = ((DataType)columnMetadata.getType().getTypeArguments().get(1)).getName();
                Validator.validateTableTrue(realMapKeyType == expectedMapKeyType, "Column %s' of table '%s' of type 'Map<%s,?>' should be of type 'Map<%s,?>' indeed", cql3ColumnName, tableName, realMapKeyType, expectedMapKeyType);
                Validator.validateTableTrue(realMapValueType == expectedValueType, "Column '%s' of table '%s' of type 'Map<?,%s>' should be of type 'Map<?,%s>' indeed", cql3ColumnName, tableName, realMapValueType, expectedValueType);
                break;
            }
        }
    }

    public void validateClusteredCounterColumn(TableMetadata tableMetaData, EntityMeta entityMeta) {
        String cql3ColumnName = this.meta.getCQL3ColumnName();
        if (log.isDebugEnabled()) {
            log.debug("Validate existing counter column {} from table {} against type {}", new Object[]{cql3ColumnName, tableMetaData.getName(), Counter.class});
        }
        boolean schemaUpdateEnabled = entityMeta.config().isSchemaUpdateEnabled();
        String tableName = tableMetaData.getName();
        ColumnMetadata columnMetadata = tableMetaData.getColumn(cql3ColumnName);
        if (schemaUpdateEnabled && columnMetadata == null) {
            return;
        }
        Validator.validateTableTrue(columnMetadata != null, "Cannot find column '%s' in the table '%s'", cql3ColumnName, tableName);
        DataType.Name realType = columnMetadata.getType().getName();
        Validator.validateTableTrue(realType == DataType.Name.COUNTER, "Column '%s' of table '%s' of type '%s' should be of type '%s' indeed", cql3ColumnName, tableName, realType, DataType.Name.COUNTER);
    }

    private void validateStatic(String cql3ColumnName, String tableName, ColumnMetadata columnMetadata) {
        Validator.validateBeanMappingTrue(columnMetadata.isStatic() == this.meta.isStaticColumn(), "Column '%s' of table '%s' is declared as static='%s' in Java but as static='%s' in Cassandra", cql3ColumnName, tableName, this.meta.isStaticColumn(), columnMetadata.isStatic());
    }

    private void validatePartitionComponent(TableMetadata tableMetaData, PropertyMeta partitionMeta) {
        ColumnMetadata columnMetadata;
        String tableName = tableMetaData.getName();
        String cql3ColumnName = partitionMeta.getCQL3ColumnName();
        Class columnJavaType = partitionMeta.config().getCQL3ValueType();
        if (log.isDebugEnabled()) {
            log.debug("Validate existing partition key component {} from table {} against type {}", new Object[]{cql3ColumnName, tableName, columnJavaType.getCanonicalName()});
        }
        Validator.validateTableTrue((columnMetadata = tableMetaData.getColumn(cql3ColumnName)) != null, "Cannot find column '%s' in the table '%s'", cql3ColumnName, tableName);
        this.validateColumnType(tableName, cql3ColumnName, columnMetadata, columnJavaType);
        Validator.validateBeanMappingTrue(this.hasColumnMeta(tableMetaData.getPartitionKey(), columnMetadata), "Column '%s' of table '%s' should be a partition key component", cql3ColumnName, tableName);
    }

    private void validateClusteringComponent(TableMetadata tableMetaData, PropertyMeta clusteringMeta) {
        ColumnMetadata columnMetadata;
        String tableName = tableMetaData.getName();
        String cql3ColumnName = clusteringMeta.getCQL3ColumnName();
        Class columnJavaType = clusteringMeta.config().getCQL3ValueType();
        if (log.isDebugEnabled()) {
            log.debug("Validate existing clustering column {} from table {} against type {}", new Object[]{cql3ColumnName, tableName, columnJavaType});
        }
        Validator.validateTableTrue((columnMetadata = tableMetaData.getColumn(cql3ColumnName)) != null, "Cannot find column '%s' in the table '%s'", cql3ColumnName, tableName);
        this.validateColumnType(tableName, cql3ColumnName, columnMetadata, columnJavaType);
        Validator.validateBeanMappingTrue(this.hasColumnMeta(tableMetaData.getClusteringColumns(), columnMetadata), "Column '%s' of table '%s' should be a clustering key component", cql3ColumnName, tableName);
    }

    private void validateColumnType(String tableName, String columnName, ColumnMetadata columnMetadata, Class<?> columnJavaType) {
        DataType.Name expectedType = TypeMapper.toCQLType(columnJavaType);
        DataType.Name realType = columnMetadata.getType().getName();
        if (realType == DataType.Name.CUSTOM) {
            realType = DataType.Name.BLOB;
        }
        Validator.validateTableTrue(expectedType == realType, "Column '%s' of table '%s' of type '%s' should be of type '%s' indeed", columnName, tableName, realType, expectedType);
    }

    private boolean hasColumnMeta(Collection<ColumnMetadata> columnMetadatas, ColumnMetadata columnMetaToVerify) {
        boolean fqcnColumnMatches = false;
        for (ColumnMetadata columnMetadata : columnMetadatas) {
            fqcnColumnMatches = fqcnColumnMatches || this.columnMetaDataComparator.isEqual(columnMetaToVerify, columnMetadata);
        }
        return fqcnColumnMatches;
    }
}

