/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaView;
import info.archinnov.achilles.internal.metadata.holder.PropertyType;
import info.archinnov.achilles.internal.persistence.operations.InternalCounterImpl;
import info.archinnov.achilles.internal.validation.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMetaTranscoder
extends PropertyMetaView {
    private static final Logger log = LoggerFactory.getLogger(PropertyMetaTranscoder.class);

    protected PropertyMetaTranscoder(PropertyMeta meta) {
        super(meta);
    }

    public Object decodeFromComponents(List<?> components) {
        if (log.isTraceEnabled()) {
            log.trace("Decode CQL3 components {} into compound primary key {} for entity class {}", new Object[]{components, this.meta.getPropertyName(), this.meta.getEntityClassName()});
        }
        Validator.validateTrue(this.meta.type() == PropertyType.EMBEDDED_ID, "Cannot decode components '%s' for the property '%s' which is not a compound primary key", components, this.meta.propertyName);
        if (CollectionUtils.isEmpty(components)) {
            return components;
        }
        Object newInstance = this.meta.forValues().instantiate();
        List propertyMetas = this.meta.getEmbeddedIdProperties().propertyMetas;
        Validator.validateTrue(components.size() == propertyMetas.size(), "There should be exactly '%s' Cassandra columns to decode into an '%s' instance", propertyMetas.size(), newInstance.getClass().getCanonicalName());
        for (int i = 0; i < propertyMetas.size(); ++i) {
            PropertyMeta componentMeta = (PropertyMeta)propertyMetas.get(i);
            Object decodedValue = componentMeta.forTranscoding().decodeFromCassandra(components.get(i));
            componentMeta.forValues().setValueToField(newInstance, decodedValue);
        }
        return newInstance;
    }

    Object decodeFromCassandra(Object fromCassandra) {
        if (log.isTraceEnabled()) {
            log.trace("Decode Cassandra value {} into Java for property {} of entity class {}", new Object[]{fromCassandra, this.meta.getPropertyName(), this.meta.getEntityClassName()});
        }
        switch (this.meta.type()) {
            case SIMPLE: 
            case ID: {
                return this.meta.getSimpleCodec().decode(fromCassandra);
            }
            case LIST: {
                return this.meta.getListCodec().decode((List)fromCassandra);
            }
            case SET: {
                return this.meta.getSetCodec().decode((Set)fromCassandra);
            }
            case MAP: {
                return this.meta.getMapCodec().decode((Map)fromCassandra);
            }
        }
        throw new AchillesException(String.format("Cannot decode value '%s' from CQL3 for property '%s' of type '%s'", fromCassandra, this.meta.propertyName, this.meta.type().name()));
    }

    public <T> T encodeToCassandra(Object fromJava) {
        if (log.isTraceEnabled()) {
            log.trace("Encode Java value {} into Cassandra for property {} of entity class {}", new Object[]{fromJava, this.meta.getPropertyName(), this.meta.getEntityClassName()});
        }
        switch (this.meta.type()) {
            case SIMPLE: 
            case ID: {
                return (T)this.meta.getSimpleCodec().encode(fromJava);
            }
            case LIST: {
                return (T)this.meta.getListCodec().encode((List)fromJava);
            }
            case SET: {
                return (T)this.meta.getSetCodec().encode((Set)fromJava);
            }
            case MAP: {
                return (T)this.meta.getMapCodec().encode((Map)fromJava);
            }
            case COUNTER: {
                return (T)((InternalCounterImpl)fromJava).getInternalCounterDelta();
            }
        }
        throw new AchillesException(String.format("Cannot encode value '%s' to CQL3 for property '%s' of type '%s'", fromJava, this.meta.propertyName, this.meta.type().name()));
    }

    public Object getAndEncodeValueForCassandra(Object entity) {
        Object value;
        if (log.isTraceEnabled()) {
            log.trace("Get and encode Java value into Cassandra for property {} of entity class {} from entity ", new Object[]{this.meta.getPropertyName(), this.meta.getEntityClassName(), entity});
        }
        if ((value = this.meta.forValues().getValueFromField(entity)) != null) {
            return this.encodeToCassandra(value);
        }
        return null;
    }

    public List<Object> encodeToComponents(Object compoundKey, boolean onlyPartitionComponents) {
        log.trace("Encode compound primary key {} to CQL3 components with 'onlyPartitionComponents' : {}", compoundKey, (Object)onlyPartitionComponents);
        Validator.validateTrue(this.meta.type() == PropertyType.EMBEDDED_ID, "Cannot encode object '%s' for the property '%s' which is not a compound primary key", compoundKey, this.meta.propertyName);
        ArrayList<Object> encoded = new ArrayList<Object>();
        if (compoundKey == null) {
            return encoded;
        }
        if (onlyPartitionComponents) {
            for (PropertyMeta partitionKeyMeta : this.meta.getEmbeddedIdProperties().getPartitionComponents().propertyMetas) {
                encoded.add(partitionKeyMeta.forTranscoding().getAndEncodeValueForCassandra(compoundKey));
            }
        } else {
            for (PropertyMeta partitionKeyMeta : this.meta.getEmbeddedIdProperties().propertyMetas) {
                encoded.add(partitionKeyMeta.forTranscoding().getAndEncodeValueForCassandra(compoundKey));
            }
        }
        return encoded;
    }

    List<Object> encodePartitionComponents(List<Object> rawPartitionComponents) {
        log.trace("Encode {} to CQL partition components", rawPartitionComponents);
        Validator.validateTrue(this.meta.type() == PropertyType.EMBEDDED_ID, "Cannot encode partition components '%s' for the property '%s' which is not a compound primary key", rawPartitionComponents, this.meta.propertyName);
        List partitionMetas = this.meta.getEmbeddedIdProperties().getPartitionComponents().propertyMetas;
        Validator.validateTrue(rawPartitionComponents.size() <= partitionMetas.size(), "There should be no more than '%s' partition components to be encoded for class '%s'", rawPartitionComponents, this.meta.getEntityClassName());
        return this.encodeElements(rawPartitionComponents, partitionMetas);
    }

    List<Object> encodePartitionComponentsIN(List<Object> rawPartitionComponentsIN) {
        log.trace("Encode {} to CQL partition components IN", rawPartitionComponentsIN);
        Validator.validateTrue(this.meta.type() == PropertyType.EMBEDDED_ID, "Cannot encode partition components '%s' for the property '%s' which is not a compound primary key", rawPartitionComponentsIN, this.meta.propertyName);
        List partitionMetas = this.meta.getEmbeddedIdProperties().getPartitionComponents().propertyMetas;
        PropertyMeta lastPartitionComponentMeta = (PropertyMeta)partitionMetas.get(partitionMetas.size() - 1);
        return this.encodeLastComponent(rawPartitionComponentsIN, lastPartitionComponentMeta);
    }

    List<Object> encodeClusteringKeys(List<Object> rawClusteringKeys) {
        log.trace("Encode {} to CQL clustering keys", rawClusteringKeys);
        Validator.validateTrue(this.meta.type() == PropertyType.EMBEDDED_ID, "Cannot encode clustering components '%s' for the property '%s' which is not a compound primary key", rawClusteringKeys, this.meta.propertyName);
        List clusteringMetas = this.meta.getEmbeddedIdProperties().getClusteringComponents().propertyMetas;
        Validator.validateTrue(rawClusteringKeys.size() <= clusteringMetas.size(), "There should be no more than '%s' clustering components to be encoded for class '%s'", rawClusteringKeys, this.meta.getEntityClassName());
        return this.encodeElements(rawClusteringKeys, clusteringMetas);
    }

    List<Object> encodeClusteringKeysIN(List<Object> rawClusteringKeysIN) {
        log.trace("Encode {} to CQL clustering keys IN", rawClusteringKeysIN);
        Validator.validateTrue(this.meta.type() == PropertyType.EMBEDDED_ID, "Cannot encode clustering components '%s' for the property '%s' which is not a compound primary key", rawClusteringKeysIN, this.meta.propertyName);
        List clusteringMetas = this.meta.getEmbeddedIdProperties().getClusteringComponents().propertyMetas;
        PropertyMeta lastClusteringKeyMeta = (PropertyMeta)clusteringMetas.get(clusteringMetas.size() - 1);
        return this.encodeLastComponent(rawClusteringKeysIN, lastClusteringKeyMeta);
    }

    private List<Object> encodeElements(List<Object> rawPartitionComponents, List<PropertyMeta> propertyMetas) {
        ArrayList<Object> encoded = new ArrayList<Object>();
        for (int i = 0; i < rawPartitionComponents.size(); ++i) {
            PropertyMeta componentMeta = propertyMetas.get(i);
            encoded.add(componentMeta.forTranscoding().encodeToCassandra(rawPartitionComponents.get(i)));
        }
        return encoded;
    }

    private List<Object> encodeLastComponent(List<Object> rawPartitionComponentsIN, PropertyMeta lastComponentMeta) {
        ArrayList<Object> encoded = new ArrayList<Object>();
        for (Object rawPartitionComponentIN : rawPartitionComponentsIN) {
            encoded.add(lastComponentMeta.forTranscoding().encodeToCassandra(rawPartitionComponentIN));
        }
        return encoded;
    }

    public String forceEncodeToJSONForCounter(Object object) {
        if (log.isTraceEnabled()) {
            log.trace("Force encode {} to JSON for property {} of entity class {}", new Object[]{object, this.meta.getPropertyName(), this.meta.getEntityClassName()});
        }
        Validator.validateNotNull(object, "Cannot encode to JSON null primary key for class '%s'", this.meta.getEntityClassName());
        if (object instanceof String) {
            return (String)String.class.cast(object);
        }
        try {
            return this.meta.defaultJacksonMapperForCounter.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new AchillesException(String.format("Error while encoding primary key '%s' for class '%s'", object, this.meta.getEntityClassName()), (Throwable)e);
        }
    }
}

