/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaView;
import info.archinnov.achilles.internal.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMetaTypedQuery
extends PropertyMetaView {
    private static final Logger log = LoggerFactory.getLogger(PropertyMetaTypedQuery.class);

    protected PropertyMetaTypedQuery(PropertyMeta meta) {
        super(meta);
    }

    public void validateTypedQuery(String queryString) {
        log.trace("Validate typed query string {} for entity class {}", (Object)queryString, (Object)this.meta.getEntityClassName());
        if (this.meta.structure().isEmbeddedId()) {
            for (String component : this.meta.getEmbeddedIdProperties().getCQL3ComponentNames()) {
                Validator.validateTrue(queryString.contains(component), "The typed query [%s] should contain the component column '%s' for embedded id type '%s'", queryString, component, this.meta.getCql3ValueClass().getCanonicalName());
            }
        } else {
            Validator.validateTrue(queryString.contains(this.meta.getCQL3ColumnName()), "The typed query [%s] should contain the id column '%s'", queryString, this.meta.getCQL3ColumnName());
        }
    }
}

