/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaView;
import info.archinnov.achilles.internal.reflection.ReflectionInvoker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMetaValues
extends PropertyMetaView {
    private static final Logger log = LoggerFactory.getLogger(PropertyMetaValues.class);
    ReflectionInvoker invoker = ReflectionInvoker.Singleton.INSTANCE.get();

    protected PropertyMetaValues(PropertyMeta meta) {
        super(meta);
    }

    public Object getPrimaryKey(Object entity) {
        if (log.isTraceEnabled()) {
            log.trace("Extract primary from entity {} of class {}", entity, (Object)this.meta.getEntityClassName());
        }
        if (this.meta.type().isId()) {
            return this.invoker.getPrimaryKey(entity, this.meta);
        }
        throw new IllegalStateException("Cannot get primary key on a non id field '" + this.meta.propertyName + "'");
    }

    public Object instantiate() {
        if (log.isTraceEnabled()) {
            log.trace("Instantiate new entity of class {}", (Object)this.meta.getEntityClassName());
        }
        return this.invoker.instantiate(this.meta.getValueClass());
    }

    public Object getValueFromField(Object target) {
        return this.invoker.getValueFromField(target, this.meta.getField());
    }

    public void setValueToField(Object target, Object args) {
        this.invoker.setValueToField(target, this.meta.getField(), args);
    }

    public Object nullValueForCollectionAndMap() {
        Cloneable value = null;
        if (this.meta.isEmptyCollectionAndMapIfNull()) {
            switch (this.meta.type()) {
                case LIST: {
                    value = new ArrayList();
                    break;
                }
                case SET: {
                    value = new HashSet();
                    break;
                }
                case MAP: {
                    value = new HashMap();
                    break;
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Get null or empty collection & map {} for property {} of entity class {}", new Object[]{value, this.meta.getPropertyName(), this.meta.getEntityClassName()});
        }
        return value;
    }

    public Object forceLoad(Object target) {
        return this.invoker.getValueFromField(target, this.meta.getGetter());
    }
}

