/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import info.archinnov.achilles.internal.metadata.util.PropertyTypeExclude;
import info.archinnov.achilles.internal.metadata.util.PropertyTypeFilter;

public enum PropertyType {
    ID,
    EMBEDDED_ID,
    SIMPLE,
    LIST,
    SET,
    MAP,
    COUNTER;

    public static final PropertyTypeFilter COUNTER_TYPE;
    public static final PropertyTypeFilter EMBEDDED_ID_TYPE;
    public static final PropertyTypeExclude EXCLUDE_ID_TYPES;
    public static final PropertyTypeExclude EXCLUDE_EMBEDDED_ID_TYPE;
    public static final PropertyTypeExclude EXCLUDE_COUNTER_TYPE;
    public static final PropertyTypeExclude EXCLUDE_ID_AND_COUNTER_TYPE;

    public boolean isCounter() {
        return this == COUNTER;
    }

    public boolean isId() {
        return this == ID || this == EMBEDDED_ID;
    }

    public boolean isEmbeddedId() {
        return this == EMBEDDED_ID;
    }

    public boolean isValidClusteredValueType() {
        return this == SIMPLE || this == COUNTER;
    }

    public boolean isCollectionAndMap() {
        return this == LIST || this == SET || this == MAP;
    }

    static {
        COUNTER_TYPE = new PropertyTypeFilter(COUNTER);
        EMBEDDED_ID_TYPE = new PropertyTypeFilter(EMBEDDED_ID);
        EXCLUDE_ID_TYPES = new PropertyTypeExclude(ID, EMBEDDED_ID);
        EXCLUDE_EMBEDDED_ID_TYPE = new PropertyTypeExclude(EMBEDDED_ID);
        EXCLUDE_COUNTER_TYPE = new PropertyTypeExclude(COUNTER);
        EXCLUDE_ID_AND_COUNTER_TYPE = new PropertyTypeExclude(ID, EMBEDDED_ID, COUNTER);
    }
}

