/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import info.archinnov.achilles.annotations.Enumerated;
import info.archinnov.achilles.annotations.TypeTransformer;
import info.archinnov.achilles.codec.Codec;
import info.archinnov.achilles.internal.metadata.codec.ByteArrayCodec;
import info.archinnov.achilles.internal.metadata.codec.ByteArrayPrimitiveCodec;
import info.archinnov.achilles.internal.metadata.codec.ByteCodec;
import info.archinnov.achilles.internal.metadata.codec.EnumNameCodec;
import info.archinnov.achilles.internal.metadata.codec.EnumOrdinalCodec;
import info.archinnov.achilles.internal.metadata.codec.JSONCodec;
import info.archinnov.achilles.internal.metadata.codec.ListCodec;
import info.archinnov.achilles.internal.metadata.codec.ListCodecImpl;
import info.archinnov.achilles.internal.metadata.codec.MapCodec;
import info.archinnov.achilles.internal.metadata.codec.MapCodecBuilder;
import info.archinnov.achilles.internal.metadata.codec.NativeCodec;
import info.archinnov.achilles.internal.metadata.codec.SetCodec;
import info.archinnov.achilles.internal.metadata.codec.SetCodecImpl;
import info.archinnov.achilles.internal.metadata.holder.InternalTimeUUID;
import info.archinnov.achilles.internal.metadata.parsing.PropertyFilter;
import info.archinnov.achilles.internal.metadata.parsing.PropertyParser;
import info.archinnov.achilles.internal.metadata.parsing.TypeParser;
import info.archinnov.achilles.internal.metadata.parsing.TypeTransformerParser;
import info.archinnov.achilles.internal.metadata.parsing.context.PropertyParsingContext;
import info.archinnov.achilles.type.Counter;
import info.archinnov.achilles.type.Pair;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecFactory {
    private static final Logger log = LoggerFactory.getLogger(CodecFactory.class);
    private static final Function<Enumerated, Enumerated.Encoding> keyEncoding = new Function<Enumerated, Enumerated.Encoding>(){

        public Enumerated.Encoding apply(Enumerated input) {
            return input.key();
        }
    };
    private static final Function<Enumerated, Enumerated.Encoding> valueEncoding = new Function<Enumerated, Enumerated.Encoding>(){

        public Enumerated.Encoding apply(Enumerated input) {
            return input.value();
        }
    };
    protected PropertyFilter filter = PropertyFilter.Singleton.INSTANCE.get();
    protected TypeTransformerParser typeTransformerParser = TypeTransformerParser.Singleton.INSTANCE.get();

    Codec parseSimpleField(PropertyParsingContext context) {
        Field field = context.getCurrentField();
        log.debug("Parse simple codec for field {}", (Object)field);
        Class<?> type = field.getType();
        if (this.filter.hasAnnotation(field, TypeTransformer.class)) {
            return this.typeTransformerParser.parseAndValidateSimpleCodec(field);
        }
        Optional maybeEncoding = Optional.fromNullable((Object)field.getAnnotation(Enumerated.class)).transform(valueEncoding);
        return this.createSimpleCodec(context, type, (Optional<Enumerated.Encoding>)maybeEncoding);
    }

    ListCodec parseListField(PropertyParsingContext context) {
        Field field = context.getCurrentField();
        log.debug("Parse list codec for field {}", (Object)field);
        if (this.filter.hasAnnotation(field, TypeTransformer.class)) {
            return this.typeTransformerParser.parseAndValidateListCodec(field);
        }
        Codec simpleCodec = this.createSimpleCodecForCollection(context);
        return new ListCodecImpl(simpleCodec.sourceType(), simpleCodec.targetType(), simpleCodec);
    }

    SetCodec parseSetField(PropertyParsingContext context) {
        Field field = context.getCurrentField();
        log.debug("Parse set codec for field {}", (Object)field);
        if (this.filter.hasAnnotation(field, TypeTransformer.class)) {
            return this.typeTransformerParser.parseAndValidateSetCodec(field);
        }
        Codec simpleCodec = this.createSimpleCodecForCollection(context);
        return new SetCodecImpl(simpleCodec.sourceType(), simpleCodec.targetType(), simpleCodec);
    }

    MapCodec parseMapField(PropertyParsingContext context) {
        Field field = context.getCurrentField();
        log.debug("Parse map codec for field {}", (Object)field);
        if (this.filter.hasAnnotation(field, TypeTransformer.class)) {
            return this.typeTransformerParser.parseAndValidateMapCodec(field);
        }
        Optional maybeEncodingKey = Optional.fromNullable((Object)field.getAnnotation(Enumerated.class)).transform(keyEncoding);
        Optional maybeEncodingValue = Optional.fromNullable((Object)field.getAnnotation(Enumerated.class)).transform(valueEncoding);
        Pair sourceTargetTypes = TypeParser.determineMapGenericTypes(field);
        Codec keyCodec = this.createSimpleCodec(context, (Class)sourceTargetTypes.left, (Optional<Enumerated.Encoding>)maybeEncodingKey);
        Codec valueCodec = this.createSimpleCodec(context, (Class)sourceTargetTypes.right, (Optional<Enumerated.Encoding>)maybeEncodingValue);
        return MapCodecBuilder.fromKeyType(keyCodec.sourceType()).toKeyType(keyCodec.targetType()).withKeyCodec(keyCodec).fromValueType(valueCodec.sourceType()).toValueType(valueCodec.targetType()).withValueCodec(valueCodec);
    }

    Class<?> determineCQL3ValueType(Codec simpleCodec, boolean timeUUID) {
        log.trace("Determine CQL3 type for type {}", (Object)simpleCodec.sourceType());
        return this.determineType(simpleCodec.targetType(), timeUUID);
    }

    Class<?> determineCQL3ValueType(ListCodec listCodec, boolean timeUUID) {
        log.trace("Determine CQL3 type for list type {}", listCodec.sourceType());
        return this.determineType(listCodec.targetType(), timeUUID);
    }

    Class<?> determineCQL3ValueType(SetCodec setCodec, boolean timeUUID) {
        log.trace("Determine CQL3 type for set type {}", setCodec.sourceType());
        return this.determineType(setCodec.targetType(), timeUUID);
    }

    Class<?> determineCQL3ValueType(MapCodec mapCodec, boolean timeUUID) {
        log.trace("Determine CQL3 type for map type {}", mapCodec.sourceValueType());
        return this.determineType(mapCodec.targetValueType(), timeUUID);
    }

    Class<?> determineCQL3KeyType(MapCodec mapCodec, boolean timeUUID) {
        log.trace("Determine CQL3 type for type {}", mapCodec.sourceKeyType());
        return this.determineType(mapCodec.targetKeyType(), timeUUID);
    }

    private Class<?> determineType(Class<?> input, boolean timeUUID) {
        if (timeUUID && UUID.class.isAssignableFrom(input)) {
            return InternalTimeUUID.class;
        }
        if (ByteBuffer.class.isAssignableFrom(input)) {
            return ByteBuffer.class;
        }
        if (Counter.class == input) {
            return Long.class;
        }
        return input;
    }

    private Codec createSimpleCodec(PropertyParsingContext context, Class type, Optional<Enumerated.Encoding> maybeEncoding) {
        log.debug("Create simple codec for java type {}", (Object)type);
        Object codec = Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type) ? new ByteCodec() : (byte[].class.isAssignableFrom(type) ? new ByteArrayPrimitiveCodec() : (Byte[].class.isAssignableFrom(type) ? new ByteArrayCodec() : (PropertyParser.isAssignableFromNativeType(type) ? new NativeCodec(type) : (type.isEnum() ? this.createEnumCodec(type, maybeEncoding) : new JSONCodec(context.getCurrentObjectMapper(), type)))));
        return codec;
    }

    private Codec createEnumCodec(Class type, Optional<Enumerated.Encoding> maybeEncoding) {
        log.debug("Create enum codec for java type {}", (Object)type);
        List enumConstants = Arrays.asList(type.getEnumConstants());
        Object codec = maybeEncoding.isPresent() ? (maybeEncoding.get() == Enumerated.Encoding.NAME ? new EnumNameCodec(enumConstants, type) : new EnumOrdinalCodec(enumConstants, type)) : new EnumNameCodec(enumConstants, type);
        return codec;
    }

    private Codec createSimpleCodecForCollection(PropertyParsingContext context) {
        Field field = context.getCurrentField();
        Optional maybeEncoding = Optional.fromNullable((Object)field.getAnnotation(Enumerated.class)).transform(valueEncoding);
        Class valueType = TypeParser.inferValueClassForListOrSet(field.getGenericType(), field.getClass());
        return this.createSimpleCodec(context, valueType, (Optional<Enumerated.Encoding>)maybeEncoding);
    }

    public static enum Singleton {
        INSTANCE;

        private final CodecFactory instance = new CodecFactory();

        public CodecFactory get() {
            return this.instance;
        }
    }
}

