/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import info.archinnov.achilles.annotations.Column;
import info.archinnov.achilles.annotations.Order;
import info.archinnov.achilles.annotations.PartitionKey;
import info.archinnov.achilles.exception.AchillesBeanMappingException;
import info.archinnov.achilles.internal.metadata.holder.EmbeddedIdProperties;
import info.archinnov.achilles.internal.metadata.holder.EmbeddedIdPropertiesBuilder;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.parsing.EntityIntrospector;
import info.archinnov.achilles.internal.metadata.parsing.PropertyFilter;
import info.archinnov.achilles.internal.metadata.parsing.PropertyParser;
import info.archinnov.achilles.internal.metadata.parsing.context.PropertyParsingContext;
import info.archinnov.achilles.internal.metadata.parsing.validator.PropertyParsingValidator;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.schemabuilder.Create;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedIdParser {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedIdParser.class);
    private EntityIntrospector introspector = EntityIntrospector.Singleton.INSTANCE.get();
    private PropertyFilter filter = PropertyFilter.Singleton.INSTANCE.get();
    private final PropertyParsingContext context;

    public EmbeddedIdParser(PropertyParsingContext context) {
        this.context = context;
    }

    public EmbeddedIdProperties parseEmbeddedId(Class<?> embeddedIdClass, PropertyParser propertyParser) {
        log.debug("Parse embedded id class {} ", (Object)embeddedIdClass.getCanonicalName());
        Map<Integer, Field> components = this.extractComponentsOrdering(embeddedIdClass);
        this.validateConsistentPartitionKeys(components, embeddedIdClass.getCanonicalName());
        List<Create.Options.ClusteringOrder> clusteringOrders = this.extractClusteringOrder(embeddedIdClass);
        EmbeddedIdProperties embeddedIdProperties = this.buildComponentMetas(propertyParser, embeddedIdClass, components, clusteringOrders);
        log.trace("Built embeddedId properties : {}", (Object)embeddedIdProperties);
        return embeddedIdProperties;
    }

    private Map<Integer, Field> extractComponentsOrdering(Class<?> embeddedIdClass) {
        log.trace("Extract components ordering from embedded id class {} ", (Object)embeddedIdClass.getCanonicalName());
        String embeddedIdClassName = embeddedIdClass.getCanonicalName();
        TreeMap<Integer, Field> components = new TreeMap<Integer, Field>();
        Set candidateFields = ReflectionUtils.getAllFields(embeddedIdClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Order.class)});
        HashSet<Integer> orders = new HashSet<Integer>();
        int orderSum = 0;
        int componentCount = candidateFields.size();
        for (Field candidateField : candidateFields) {
            Order orderAnnotation = candidateField.getAnnotation(Order.class);
            int order = orderAnnotation.value();
            Class<?> componentType = candidateField.getType();
            orderSum = this.validateNoDuplicateOrderAndType(embeddedIdClassName, orders, orderSum, order, componentType);
            components.put(order, candidateField);
        }
        this.validateConsistentOrdering(embeddedIdClassName, orderSum, componentCount);
        Validator.validateBeanMappingTrue(componentCount > 1, "There should be at least 2 fields annotated with @Order for the @EmbeddedId class '%s'", embeddedIdClass.getCanonicalName());
        return components;
    }

    private List<Create.Options.ClusteringOrder> extractClusteringOrder(Class<?> embeddedIdClass) {
        log.debug("Extract clustering component order from embedded id class {} ", (Object)embeddedIdClass.getCanonicalName());
        LinkedList<Create.Options.ClusteringOrder> sortOrders = new LinkedList<Create.Options.ClusteringOrder>();
        Set candidateFields = ReflectionUtils.getAllFields(embeddedIdClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Order.class)});
        ImmutableList clusteringFields = FluentIterable.from((Iterable)candidateFields).filter((Predicate)new Predicate<Field>(){

            public boolean apply(Field field) {
                Order orderAnnotation = field.getAnnotation(Order.class);
                return !EmbeddedIdParser.this.filter.hasAnnotation(field, PartitionKey.class) && orderAnnotation.value() > 1;
            }
        }).toSortedList((Comparator)new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                Order order1 = o1.getAnnotation(Order.class);
                Order order2 = o2.getAnnotation(Order.class);
                return new Integer(order1.value()).compareTo(new Integer(order2.value()));
            }
        });
        for (Field clusteringField : clusteringFields) {
            Order order = clusteringField.getAnnotation(Order.class);
            String cqlColumnName = this.introspector.inferCQLColumnName(clusteringField, this.context.getClassNamingStrategy());
            this.validateNotStaticColumn(clusteringField);
            sortOrders.add(new Create.Options.ClusteringOrder(cqlColumnName, order.reversed() ? Create.Options.ClusteringOrder.Sorting.DESC : Create.Options.ClusteringOrder.Sorting.ASC));
        }
        return sortOrders;
    }

    private int validateNoDuplicateOrderAndType(String embeddedIdClassName, Set<Integer> orders, int orderSum, int order, Class<?> componentType) {
        log.debug("Validate type and component ordering for embedded id class {} ", (Object)embeddedIdClassName);
        Validator.validateBeanMappingTrue(orders.add(order), "The order '%s' is duplicated in @EmbeddedId class '%s'", order, embeddedIdClassName);
        PropertyParsingValidator.validateAllowedTypes(componentType, PropertyParser.allowedTypes, "The class '" + componentType.getCanonicalName() + "' is not a valid component type for the @EmbeddedId class '" + embeddedIdClassName + "'");
        return orderSum += order;
    }

    private void validateConsistentOrdering(String embeddedIdClassName, int orderSum, int componentCount) {
        int check = componentCount * (componentCount + 1) / 2;
        log.debug("Validate component ordering for @EmbeddedId class {} ", (Object)embeddedIdClassName);
        Validator.validateBeanMappingTrue(orderSum == check, "The component ordering is wrong for @EmbeddedId class '%s'", embeddedIdClassName);
    }

    private void validateConsistentPartitionKeys(Map<Integer, Field> componentsOrdering, String embeddedIdClassName) {
        log.debug("Validate composite partition key component ordering for @EmbeddedId class {} ", (Object)embeddedIdClassName);
        int orderSum = 0;
        int orderCount = 0;
        for (Integer order : componentsOrdering.keySet()) {
            Field componentField = componentsOrdering.get(order);
            if (!this.filter.hasAnnotation(componentField, PartitionKey.class)) continue;
            orderSum += order.intValue();
            ++orderCount;
        }
        int check = orderCount * (orderCount + 1) / 2;
        Validator.validateBeanMappingTrue(orderSum == check, "The composite partition key ordering is wrong for @EmbeddedId class '%s'", embeddedIdClassName);
    }

    private EmbeddedIdProperties buildComponentMetas(PropertyParser propertyParser, Class<?> embeddedIdClass, Map<Integer, Field> components, List<Create.Options.ClusteringOrder> clusteringOrders) {
        log.debug("Build components meta data for embedded id class {}", (Object)embeddedIdClass.getCanonicalName());
        EmbeddedIdPropertiesBuilder partitionKeysBuilder = new EmbeddedIdPropertiesBuilder();
        EmbeddedIdPropertiesBuilder clusteringKeysBuilder = new EmbeddedIdPropertiesBuilder();
        clusteringKeysBuilder.setClusteringOrders(clusteringOrders);
        this.buildPartitionAndClusteringKeys(propertyParser, embeddedIdClass, components, partitionKeysBuilder, clusteringKeysBuilder);
        return EmbeddedIdPropertiesBuilder.buildEmbeddedIdProperties(partitionKeysBuilder.buildPartitionKeys(), clusteringKeysBuilder.buildClusteringKeys(), this.context.getCurrentEntityClass().getCanonicalName());
    }

    private void buildPartitionAndClusteringKeys(PropertyParser propertyParser, Class<?> embeddedIdClass, Map<Integer, Field> components, EmbeddedIdPropertiesBuilder partitionKeysBuilder, EmbeddedIdPropertiesBuilder clusteringKeysBuilder) {
        log.debug("Build Components meta data for embedded id class {}", (Object)embeddedIdClass.getCanonicalName());
        for (Integer order : components.keySet()) {
            Field compositeKeyField = components.get(order);
            PropertyMeta propertyMeta = propertyParser.parseSimpleProperty(this.context.duplicateForField(compositeKeyField));
            if (this.filter.hasAnnotation(compositeKeyField, PartitionKey.class)) {
                partitionKeysBuilder.addPropertyMeta(propertyMeta);
                continue;
            }
            clusteringKeysBuilder.addPropertyMeta(propertyMeta);
        }
        if (partitionKeysBuilder.getPropertyMetas().isEmpty()) {
            PropertyMeta partitionMeta = clusteringKeysBuilder.getPropertyMetas().remove(0);
            partitionKeysBuilder.addPropertyMeta(partitionMeta);
        }
    }

    private void validateNotStaticColumn(Field compositeKeyField) {
        Column column = compositeKeyField.getAnnotation(Column.class);
        if (column != null && column.staticColumn()) {
            throw new AchillesBeanMappingException(String.format("The property '%s' of class '%s' cannot be a static column because it belongs to the primary key", compositeKeyField.getName(), compositeKeyField.getDeclaringClass().getCanonicalName()));
        }
    }
}

