/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing;

import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.annotations.Column;
import info.archinnov.achilles.annotations.EmbeddedId;
import info.archinnov.achilles.annotations.Id;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.EntityMetaBuilder;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.parsing.EntityIntrospector;
import info.archinnov.achilles.internal.metadata.parsing.PropertyFilter;
import info.archinnov.achilles.internal.metadata.parsing.PropertyParser;
import info.archinnov.achilles.internal.metadata.parsing.context.EntityParsingContext;
import info.archinnov.achilles.internal.metadata.parsing.context.PropertyParsingContext;
import info.archinnov.achilles.internal.metadata.parsing.validator.EntityParsingValidator;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.type.InsertStrategy;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityParser {
    private static final Logger log = LoggerFactory.getLogger(EntityParser.class);
    private EntityParsingValidator validator = EntityParsingValidator.Singleton.INSTANCE.get();
    private PropertyParser parser = PropertyParser.Singleton.INSTANCE.get();
    private PropertyFilter filter = PropertyFilter.Singleton.INSTANCE.get();
    private EntityIntrospector introspector = EntityIntrospector.Singleton.INSTANCE.get();

    public EntityMeta parseEntity(EntityParsingContext context) {
        log.debug("Parsing entity class {}", (Object)context.getCurrentEntityClass().getCanonicalName());
        Class<?> entityClass = context.getCurrentEntityClass();
        this.validateEntityAndGetObjectMapper(context);
        String keyspaceName = context.getKeyspaceName();
        String tableName = context.getTableName();
        String tableComment = this.introspector.inferTableComment(entityClass, "Create table for entity \"" + entityClass.getName() + "\"");
        InsertStrategy insertStrategy = this.introspector.getInsertStrategy(entityClass, context);
        PropertyMeta idMeta = null;
        List<Field> inheritedFields = this.introspector.getInheritedPrivateFields(entityClass);
        for (Field field : inheritedFields) {
            PropertyParsingContext propertyContext = context.newPropertyContext(field);
            if (this.filter.hasAnnotation(field, Id.class)) {
                propertyContext.setPrimaryKey(true);
                idMeta = this.parser.parse(propertyContext);
                continue;
            }
            if (this.filter.hasAnnotation(field, EmbeddedId.class)) {
                propertyContext.setEmbeddedId(true);
                idMeta = this.parser.parse(propertyContext);
                continue;
            }
            if (this.filter.hasAnnotation(field, Column.class)) {
                this.parser.parse(propertyContext);
                continue;
            }
            log.trace("Un-mapped field {} of entity {} will not be managed by Achilles", (Object)field.getName(), (Object)context.getCurrentEntityClass().getCanonicalName());
        }
        this.validator.validateHasIdMeta(entityClass, idMeta);
        this.completeCounterPropertyMeta(context, idMeta);
        EntityMeta entityMeta = EntityMetaBuilder.entityMetaBuilder(idMeta).entityClass(entityClass).className(entityClass.getCanonicalName()).keyspaceName(keyspaceName).tableName(tableName).tableComment(tableComment).propertyMetas(context.getPropertyMetas()).consistencyLevels(context.getCurrentConsistencyLevels()).insertStrategy(insertStrategy).schemaUpdateEnabled(context.isSchemaUpdateEnabled(keyspaceName, tableName)).build();
        this.validator.validateStaticColumns(entityMeta, idMeta);
        log.trace("Entity meta built for entity class {} : {}", (Object)context.getCurrentEntityClass().getCanonicalName(), (Object)entityMeta);
        return entityMeta;
    }

    private void validateEntityAndGetObjectMapper(EntityParsingContext context) {
        Class<?> entityClass = context.getCurrentEntityClass();
        log.debug("Validate entity {}", (Object)entityClass.getCanonicalName());
        Validator.validateInstantiable(entityClass);
        ObjectMapper objectMapper = context.getObjectMapperFactory().getMapper(entityClass);
        Validator.validateNotNull(objectMapper, "No Jackson ObjectMapper found for entity '%s'", entityClass.getCanonicalName());
        log.debug("Set default object mapper {} for entity {}", (Object)objectMapper.getClass().getCanonicalName(), (Object)entityClass.getCanonicalName());
        context.setCurrentObjectMapper(objectMapper);
    }

    private void completeCounterPropertyMeta(EntityParsingContext context, PropertyMeta idMeta) {
        for (PropertyMeta counterMeta : context.getCounterMetas()) {
            log.debug("Add id Meta {} to counter meta {} of entity class {}", new Object[]{idMeta.getPropertyName(), counterMeta.getPropertyName(), context.getCurrentEntityClass().getCanonicalName()});
            counterMeta.setIdMetaForCounterProperties(idMeta);
        }
    }

    public static enum Singleton {
        INSTANCE;

        private final EntityParser instance = new EntityParser();

        public EntityParser get() {
            return this.instance;
        }
    }
}

