/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing;

import info.archinnov.achilles.exception.AchillesBeanMappingException;
import info.archinnov.achilles.type.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeParser {
    private static final Logger log = LoggerFactory.getLogger(TypeParser.class);

    static <T> Class<T> inferValueClassForListOrSet(Type genericType, Class<?> entityClass) {
        Type[] actualTypeArguments;
        log.debug("Infer parameterized value class for collection type {} of entity class {} ", (Object)genericType.toString(), (Object)entityClass.getCanonicalName());
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            actualTypeArguments = pt.getActualTypeArguments();
            if (actualTypeArguments.length <= 0) {
                throw new AchillesBeanMappingException("The type '" + genericType.getClass().getCanonicalName() + "' of the entity '" + entityClass.getCanonicalName() + "' should be parameterized");
            }
        } else {
            throw new AchillesBeanMappingException("The type '" + genericType.getClass().getCanonicalName() + "' of the entity '" + entityClass.getCanonicalName() + "' should be parameterized");
        }
        Type type = actualTypeArguments[actualTypeArguments.length - 1];
        Class<T> valueClass = TypeParser.getClassFromType(type);
        log.trace("Inferred value class : {}", (Object)valueClass.getCanonicalName());
        return valueClass;
    }

    static <K, V> Pair<Class<K>, Class<V>> determineMapGenericTypes(Field field) {
        log.trace("Determine generic types for field Map<K,V> {} of entity class {}", (Object)field.getName(), (Object)field.getDeclaringClass().getCanonicalName());
        Type genericType = field.getGenericType();
        ParameterizedType pt = (ParameterizedType)genericType;
        Type[] actualTypeArguments = pt.getActualTypeArguments();
        Class keyClass = TypeParser.getClassFromType(actualTypeArguments[0]);
        Class valueClass = TypeParser.getClassFromType(actualTypeArguments[1]);
        return Pair.create(keyClass, valueClass);
    }

    static <T> Class<T> getClassFromType(Type type) {
        log.debug("Infer class from type {}", (Object)type);
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        throw new IllegalArgumentException("Cannot determine java class of type '" + type + "'");
    }
}

