/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing;

import info.archinnov.achilles.annotations.TypeTransformer;
import info.archinnov.achilles.codec.Codec;
import info.archinnov.achilles.codec.IdentityCodec;
import info.archinnov.achilles.exception.AchillesBeanMappingException;
import info.archinnov.achilles.internal.metadata.codec.ListCodec;
import info.archinnov.achilles.internal.metadata.codec.ListCodecBuilder;
import info.archinnov.achilles.internal.metadata.codec.MapCodec;
import info.archinnov.achilles.internal.metadata.codec.MapCodecBuilder;
import info.archinnov.achilles.internal.metadata.codec.SetCodec;
import info.archinnov.achilles.internal.metadata.codec.SetCodecBuilder;
import info.archinnov.achilles.internal.metadata.parsing.PropertyParser;
import info.archinnov.achilles.internal.metadata.parsing.TypeParser;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.type.Pair;
import java.lang.reflect.Field;

public class TypeTransformerParser {
    public Codec parseAndValidateSimpleCodec(Field field) {
        String fieldName = field.getName();
        String className = field.getDeclaringClass().getCanonicalName();
        Codec<?, ?> codec = this.getValueCodecInstance(field);
        this.validateNotIdentityCodec(fieldName, className, codec);
        Class sourceType = codec.sourceType();
        Class targetType = codec.targetType();
        this.validateTypesNotNull(fieldName, className, sourceType, targetType);
        this.validateMatchingSourceType(fieldName, className, sourceType, field.getType());
        this.validateSupportedTargetType(fieldName, className, targetType);
        return codec;
    }

    public ListCodec parseAndValidateListCodec(Field field) {
        String fieldName = field.getName();
        String className = field.getDeclaringClass().getCanonicalName();
        Codec<?, ?> codec = this.getValueCodecInstance(field);
        this.validateNotIdentityCodec(fieldName, className, codec);
        Class sourceType = codec.sourceType();
        Class targetType = codec.targetType();
        this.validateTypesNotNull(fieldName, className, sourceType, targetType);
        Class listValueType = TypeParser.inferValueClassForListOrSet(field.getGenericType(), field.getDeclaringClass());
        this.validateMatchingSourceType(fieldName, className, sourceType, listValueType);
        this.validateSupportedTargetType(fieldName, className, targetType);
        return ListCodecBuilder.fromType(sourceType).toType(targetType).withCodec(codec);
    }

    public SetCodec parseAndValidateSetCodec(Field field) {
        String fieldName = field.getName();
        String className = field.getDeclaringClass().getCanonicalName();
        Codec<?, ?> codec = this.getValueCodecInstance(field);
        this.validateNotIdentityCodec(fieldName, className, codec);
        Class sourceType = codec.sourceType();
        Class targetType = codec.targetType();
        this.validateTypesNotNull(fieldName, className, sourceType, targetType);
        Class listValueType = TypeParser.inferValueClassForListOrSet(field.getGenericType(), field.getDeclaringClass());
        this.validateMatchingSourceType(fieldName, className, sourceType, listValueType);
        this.validateSupportedTargetType(fieldName, className, targetType);
        return SetCodecBuilder.fromType(sourceType).toType(targetType).withCodec(codec);
    }

    public MapCodec parseAndValidateMapCodec(Field field) {
        String fieldName = field.getName();
        String className = field.getDeclaringClass().getCanonicalName();
        Codec<?, ?> keyCodec = this.getKeyCodecInstance(field);
        Codec<?, ?> valueCodec = this.getValueCodecInstance(field);
        Validator.validateBeanMappingFalse(keyCodec instanceof IdentityCodec && valueCodec instanceof IdentityCodec, "The @TypeTransformer on the field '%s' of class '%s' should declare a key/value codec other than IdentityCodec. Maybe you forgot to provided it ?", fieldName, className);
        Pair<Class<Object>, Class<Object>> keyAndValueClass = TypeParser.determineMapGenericTypes(field);
        if (keyCodec instanceof IdentityCodec) {
            return this.buildValueMapCodec(valueCodec, field, keyAndValueClass);
        }
        if (valueCodec instanceof IdentityCodec) {
            return this.buildKeyMapCodec(keyCodec, field, keyAndValueClass);
        }
        return this.buildKeyAndValueMapCodec(keyCodec, valueCodec, field, keyAndValueClass);
    }

    private void validateNotIdentityCodec(String fieldName, String className, Codec<?, ?> codec) {
        Validator.validateBeanMappingFalse(codec instanceof IdentityCodec, "The @TypeTransformer on the field '%s' of class '%s' should declare a value codec other than IdentityCodec. Maybe you forgot to provided it ?", fieldName, className);
    }

    private void validateSupportedTargetType(String fieldName, String className, Class<?> targetType) {
        Validator.validateBeanMappingTrue(PropertyParser.isAssignableFromNativeType(targetType), "Target type '%s' declared on the field '%s' of class '%s' is not supported as primitive Cassandra data type", targetType.getCanonicalName(), fieldName, className);
    }

    private void validateMatchingSourceType(String fieldName, String className, Class<?> sourceType, Class<?> fieldType) {
        Validator.validateBeanMappingTrue(sourceType.isAssignableFrom(fieldType), "Source type '%s' of codec declared in annotation @TypeTransformer does not match Java type '%s' found on the field '%s' of class '%s'", sourceType.getCanonicalName(), fieldType.getCanonicalName(), fieldName, className);
    }

    private void validateTypesNotNull(String fieldName, String className, Class<?> sourceType, Class<?> targetType) {
        Validator.validateBeanMappingNotNull(sourceType, "Source type of codec declared in annotation @TypeTransformer on the field '%s' of class '%s' should not be null", fieldName, className);
        Validator.validateBeanMappingNotNull(targetType, "Target type of codec declared in annotation @TypeTransformer on the field '%s' of class '%s' should not be null", fieldName, className);
    }

    private Codec<?, ?> getValueCodecInstance(Field field) {
        TypeTransformer typeTransformer = field.getAnnotation(TypeTransformer.class);
        Class codecClass = typeTransformer.valueCodecClass();
        String fieldName = field.getName();
        String className = field.getDeclaringClass().getCanonicalName();
        this.validateInstanceOfCodec(codecClass, fieldName, className);
        return this.validateInstantiable(field, codecClass);
    }

    private Codec<?, ?> getKeyCodecInstance(Field field) {
        TypeTransformer typeTransformer = field.getAnnotation(TypeTransformer.class);
        Class codecClass = typeTransformer.keyCodecClass();
        String fieldName = field.getName();
        String className = field.getDeclaringClass().getCanonicalName();
        this.validateInstanceOfCodec(codecClass, fieldName, className);
        return this.validateInstantiable(field, codecClass);
    }

    private void validateInstanceOfCodec(Class<?> codecClass, String fieldName, String className) {
        Validator.validateBeanMappingTrue(Codec.class.isAssignableFrom(codecClass), "The codec class '%s' declared in @TypeTransformer on the field '%s' of class '%s' should implement the interface Codec<FROM,TO>", codecClass.getCanonicalName(), fieldName, className);
    }

    private Codec<?, ?> validateInstantiable(Field field, Class<?> codecClass) {
        try {
            return (Codec)codecClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AchillesBeanMappingException(String.format("Codec class '%s' declared on the field '%s' of class '%s' should be instantiable (declare a public constructor)", codecClass.getCanonicalName(), field.getName(), field.getDeclaringClass().getCanonicalName()));
        }
    }

    private MapCodec buildKeyMapCodec(Codec keyCodec, Field field, Pair<Class<Object>, Class<Object>> keyAndValueClass) {
        String fieldName = field.getName();
        String className = field.getDeclaringClass().getCanonicalName();
        Class sourceKeyType = keyCodec.sourceType();
        Class targetKeyType = keyCodec.targetType();
        this.validateTypesNotNull(fieldName, className, sourceKeyType, targetKeyType);
        this.validateMatchingSourceType(fieldName, className, sourceKeyType, (Class)keyAndValueClass.left);
        this.validateSupportedTargetType(fieldName, className, targetKeyType);
        return MapCodecBuilder.fromKeyType(sourceKeyType).toKeyType(targetKeyType).withKeyCodec(keyCodec).withValueType((Class)keyAndValueClass.right);
    }

    private MapCodec buildValueMapCodec(Codec valueCodec, Field field, Pair<Class<Object>, Class<Object>> keyAndValueClass) {
        String fieldName = field.getName();
        String className = field.getDeclaringClass().getCanonicalName();
        Class sourceValueType = valueCodec.sourceType();
        Class targetValueType = valueCodec.targetType();
        this.validateTypesNotNull(fieldName, className, sourceValueType, targetValueType);
        this.validateMatchingSourceType(fieldName, className, sourceValueType, (Class)keyAndValueClass.right);
        this.validateSupportedTargetType(fieldName, className, targetValueType);
        return MapCodecBuilder.withKeyType((Class)keyAndValueClass.left).fromValueType(sourceValueType).toValueType(targetValueType).withValueCodec(valueCodec);
    }

    private MapCodec buildKeyAndValueMapCodec(Codec keyCodec, Codec valueCodec, Field field, Pair<Class<Object>, Class<Object>> keyAndValueClass) {
        String fieldName = field.getName();
        String className = field.getDeclaringClass().getCanonicalName();
        Class sourceKeyType = keyCodec.sourceType();
        Class targetKeyType = keyCodec.targetType();
        Class sourceValueType = valueCodec.sourceType();
        Class targetValueType = valueCodec.targetType();
        this.validateTypesNotNull(fieldName, className, sourceKeyType, targetKeyType);
        this.validateTypesNotNull(fieldName, className, sourceValueType, targetValueType);
        this.validateMatchingSourceType(fieldName, className, sourceKeyType, (Class)keyAndValueClass.left);
        this.validateMatchingSourceType(fieldName, className, sourceValueType, (Class)keyAndValueClass.right);
        this.validateSupportedTargetType(fieldName, className, targetKeyType);
        this.validateSupportedTargetType(fieldName, className, targetValueType);
        return MapCodecBuilder.fromKeyType(sourceKeyType).toKeyType(targetKeyType).withKeyCodec(keyCodec).fromValueType(sourceValueType).toValueType(targetValueType).withValueCodec(valueCodec);
    }

    public static enum Singleton {
        INSTANCE;

        private final TypeTransformerParser instance = new TypeTransformerParser();

        public TypeTransformerParser get() {
            return this.instance;
        }
    }
}

