/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing.context;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.parsing.EntityIntrospector;
import info.archinnov.achilles.internal.metadata.parsing.context.PropertyParsingContext;
import info.archinnov.achilles.json.JacksonMapperFactory;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.InsertStrategy;
import info.archinnov.achilles.type.NamingStrategy;
import info.archinnov.achilles.type.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityParsingContext {
    private EntityIntrospector introspector = EntityIntrospector.Singleton.INSTANCE.get();
    private ConfigurationContext configContext;
    private Boolean hasCounter = false;
    private Map<String, PropertyMeta> propertyMetas = new HashMap<String, PropertyMeta>();
    private List<PropertyMeta> counterMetas = new ArrayList<PropertyMeta>();
    private Class<?> currentEntityClass;
    private ObjectMapper currentObjectMapper;
    private Pair<ConsistencyLevel, ConsistencyLevel> currentConsistencyLevels;
    private NamingStrategy namingStrategy;
    private String keyspaceName;
    private String tableName;

    public EntityParsingContext(ConfigurationContext configContext, Class<?> currentEntityClass) {
        this.configContext = configContext;
        this.currentEntityClass = currentEntityClass;
        this.namingStrategy = this.introspector.determineClassNamingStrategy(configContext, currentEntityClass);
        this.keyspaceName = this.introspector.inferKeyspaceName(currentEntityClass, configContext.getCurrentKeyspace(), this.namingStrategy);
        this.tableName = this.introspector.inferTableName(currentEntityClass, currentEntityClass.getName(), this.namingStrategy);
        this.currentConsistencyLevels = this.introspector.findConsistencyLevels(currentEntityClass, this.tableName, configContext);
    }

    private EntityParsingContext(ConfigurationContext configContext, Class<?> currentEntityClass, ObjectMapper currentObjectMapper, NamingStrategy namingStrategy, String keyspaceName, String tableName, Pair<ConsistencyLevel, ConsistencyLevel> currentConsistencyLevels) {
        this.configContext = configContext;
        this.currentEntityClass = currentEntityClass;
        this.currentObjectMapper = currentObjectMapper;
        this.namingStrategy = namingStrategy;
        this.keyspaceName = keyspaceName;
        this.tableName = tableName;
        this.currentConsistencyLevels = currentConsistencyLevels;
    }

    public PropertyParsingContext newPropertyContext(Field currentField) {
        return new PropertyParsingContext(this, currentField);
    }

    public Class<?> getCurrentEntityClass() {
        return this.currentEntityClass;
    }

    public Map<String, PropertyMeta> getPropertyMetas() {
        return this.propertyMetas;
    }

    public Boolean hasSimpleCounter() {
        return this.hasCounter;
    }

    public void setHasSimpleCounter(Boolean hasCounter) {
        this.hasCounter = hasCounter;
    }

    public ObjectMapper getCurrentObjectMapper() {
        return this.currentObjectMapper;
    }

    public void setCurrentObjectMapper(ObjectMapper currentObjectMapper) {
        this.currentObjectMapper = currentObjectMapper;
    }

    public void setCurrentConsistencyLevels(Pair<ConsistencyLevel, ConsistencyLevel> currentConsistencyLevels) {
        this.currentConsistencyLevels = currentConsistencyLevels;
    }

    public List<PropertyMeta> getCounterMetas() {
        return this.counterMetas;
    }

    public Pair<ConsistencyLevel, ConsistencyLevel> getCurrentConsistencyLevels() {
        return this.currentConsistencyLevels;
    }

    public JacksonMapperFactory getObjectMapperFactory() {
        return this.configContext.getJacksonMapperFactory();
    }

    public boolean isSchemaUpdateEnabled(String keyspaceName, String tableName) {
        String qualifiedTableName = keyspaceName + "." + tableName;
        Map<String, Boolean> columnFamilyUpdateMap = this.configContext.getEnableSchemaUpdateForTables();
        if (columnFamilyUpdateMap.containsKey(qualifiedTableName)) {
            return columnFamilyUpdateMap.get(qualifiedTableName);
        }
        return this.configContext.isEnableSchemaUpdate();
    }

    public InsertStrategy getDefaultInsertStrategy() {
        return this.configContext.getGlobalInsertStrategy();
    }

    public ConfigurationContext getConfigContext() {
        return this.configContext;
    }

    public EntityParsingContext duplicateForClass(Class<?> entityClass) {
        return new EntityParsingContext(this.configContext, entityClass, this.currentObjectMapper, this.namingStrategy, this.keyspaceName, this.tableName, this.currentConsistencyLevels);
    }

    public Optional<String> getCurrentKeyspaceName() {
        return this.configContext.getCurrentKeyspace();
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public String getTableName() {
        return this.tableName;
    }
}

