/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing.context;

import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.parsing.EntityIntrospector;
import info.archinnov.achilles.internal.metadata.parsing.context.EntityParsingContext;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.NamingStrategy;
import info.archinnov.achilles.type.Pair;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyParsingContext {
    private static final Logger log = LoggerFactory.getLogger(PropertyParsingContext.class);
    private EntityIntrospector introspector = EntityIntrospector.Singleton.INSTANCE.get();
    private EntityParsingContext context;
    private Field currentField;
    private String currentPropertyName;
    private String currentCQL3ColumnName;
    private boolean isCustomConsistencyLevels;
    private boolean primaryKey = false;
    private boolean embeddedId = false;

    public PropertyParsingContext(EntityParsingContext context, Field currentField) {
        this.context = context;
        this.currentField = currentField;
        this.currentPropertyName = currentField.getName();
        this.currentCQL3ColumnName = this.introspector.inferCQLColumnName(currentField, context.getNamingStrategy());
    }

    public ObjectMapper getCurrentObjectMapper() {
        return this.context.getCurrentObjectMapper();
    }

    public Map<String, PropertyMeta> getPropertyMetas() {
        return this.context.getPropertyMetas();
    }

    public <T> Class<T> getCurrentEntityClass() {
        return this.context.getCurrentEntityClass();
    }

    public Field getCurrentField() {
        return this.currentField;
    }

    public String getCurrentPropertyName() {
        return this.currentPropertyName;
    }

    public String getCurrentCQL3ColumnName() {
        return this.currentCQL3ColumnName;
    }

    public List<PropertyMeta> getCounterMetas() {
        return this.context.getCounterMetas();
    }

    public Pair<ConsistencyLevel, ConsistencyLevel> getCurrentConsistencyLevels() {
        return this.context.getCurrentConsistencyLevels();
    }

    public boolean isCustomConsistencyLevels() {
        return this.isCustomConsistencyLevels;
    }

    public void setCustomConsistencyLevels(boolean isCustomConsistencyLevels) {
        this.isCustomConsistencyLevels = isCustomConsistencyLevels;
    }

    public void hasSimpleCounterType() {
        this.context.setHasSimpleCounter(true);
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isEmbeddedId() {
        return this.embeddedId;
    }

    public void setEmbeddedId(boolean embeddedId) {
        if (embeddedId) {
            this.primaryKey = true;
        }
        this.embeddedId = embeddedId;
    }

    public NamingStrategy getClassNamingStrategy() {
        return this.context.getNamingStrategy();
    }

    public PropertyParsingContext duplicateForField(Field field) {
        return new PropertyParsingContext(this.context.duplicateForClass(field.getDeclaringClass()), field);
    }
}

