/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.internal.async.AsyncUtils;
import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.CounterLoader;
import info.archinnov.achilles.internal.persistence.operations.EntityMapper;
import info.archinnov.achilles.internal.persistence.operations.NullRow;
import info.archinnov.achilles.internal.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityLoader {
    private static final Logger log = LoggerFactory.getLogger(EntityLoader.class);
    private EntityMapper mapper = EntityMapper.Singleton.INSTANCE.get();
    private CounterLoader counterLoader = CounterLoader.Singleton.INSTANCE.get();
    private AsyncUtils asyncUtils = AsyncUtils.Singleton.INSTANCE.get();

    public <T> AchillesFuture<T> load(EntityOperations context, Class<T> entityClass) {
        AchillesFuture achillesFuture;
        log.debug("Loading entity of class {} using PersistenceContext {}", entityClass, (Object)context);
        final EntityMeta entityMeta = context.getEntityMeta();
        Object primaryKey = context.getPrimaryKey();
        Validator.validateNotNull(entityClass, "Entity class should not be null", new Object[0]);
        Validator.validateNotNull(primaryKey, "Entity '%s' key should not be null", entityClass.getCanonicalName());
        Validator.validateNotNull(entityMeta, "Entity meta for '%s' should not be null", entityClass.getCanonicalName());
        if (entityMeta.structure().isClusteredCounter()) {
            achillesFuture = this.counterLoader.loadClusteredCounters(context);
        } else {
            ListenableFuture<Row> futureRow = context.loadEntity();
            Function rowToEntity = new Function<Row, T>(){

                public T apply(Row row) {
                    Object entity = null;
                    if (row != null) {
                        entity = entityMeta.forOperations().instanciate();
                        EntityLoader.this.mapper.setNonCounterPropertiesToEntity(row, entityMeta, entity);
                    }
                    return entity;
                }
            };
            ListenableFuture futureEntity = this.asyncUtils.transformFuture(futureRow, rowToEntity, context.getExecutorService());
            achillesFuture = this.asyncUtils.buildInterruptible(futureEntity);
        }
        return achillesFuture;
    }

    public <T> T createEmptyEntity(EntityOperations context, Class<T> entityClass) {
        log.debug("Loading entity of class {} using PersistenceContext {}", entityClass, (Object)context);
        EntityMeta entityMeta = context.getEntityMeta();
        Object primaryKey = context.getPrimaryKey();
        Validator.validateNotNull(entityClass, "Entity class should not be null", new Object[0]);
        Validator.validateNotNull(primaryKey, "Entity '%s' key should not be null", entityClass.getCanonicalName());
        Validator.validateNotNull(entityMeta, "Entity meta for '%s' should not be null", entityClass.getCanonicalName());
        Object entity = entityMeta.forOperations().instanciate();
        entityMeta.getIdMeta().forValues().setValueToField(entity, primaryKey);
        return entity;
    }

    public void loadPropertyIntoObject(EntityOperations context, Object realObject, PropertyMeta pm) {
        log.trace("Loading property {} into object {}", (Object)pm.getPropertyName(), realObject);
        if (pm.structure().isCounter()) {
            this.counterLoader.loadCounter(context, realObject, pm);
        } else {
            Row row = context.loadProperty(pm);
            if (row == null && pm.structure().isCollectionAndMap()) {
                row = new NullRow();
            }
            this.mapper.setPropertyToEntity(row, context.getEntityMeta(), pm, realObject);
        }
    }

    public static enum Singleton {
        INSTANCE;

        private final EntityLoader instance = new EntityLoader();

        public EntityLoader get() {
            return this.instance;
        }
    }
}

