/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.persistence.operations.CounterPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityPersister {
    private static final Logger log = LoggerFactory.getLogger(EntityPersister.class);
    private CounterPersister counterPersister = CounterPersister.Singleton.INSTANCE.get();

    public void persist(EntityOperations context) {
        EntityMeta entityMeta = context.getEntityMeta();
        Object entity = context.getEntity();
        log.debug("Persisting transient entity {}", entity);
        if (entityMeta.structure().isClusteredCounter()) {
            this.counterPersister.persistClusteredCounters(context);
        } else {
            context.pushInsertStatement();
            this.counterPersister.persistCounters(context, entityMeta.getAllCounterMetas());
        }
    }

    public void delete(EntityOperations context) {
        log.trace("Deleting entity using PersistenceContext {}", (Object)context);
        EntityMeta entityMeta = context.getEntityMeta();
        if (entityMeta.structure().isClusteredCounter()) {
            context.bindForClusteredCounterDeletion();
        } else {
            context.bindForDeletion(entityMeta.config().getQualifiedTableName());
            this.counterPersister.deleteRelatedCounters(context);
        }
    }

    public static enum Singleton {
        INSTANCE;

        private final EntityPersister instance = new EntityPersister();

        public EntityPersister get() {
            return this.instance;
        }
    }
}

