/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.proxy.ProxyClassFactory;
import info.archinnov.achilles.internal.proxy.ProxyInterceptor;
import info.archinnov.achilles.internal.proxy.ProxyInterceptorBuilder;
import info.archinnov.achilles.internal.reflection.ObjectInstantiator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.NoOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityProxifier {
    private static final Logger log = LoggerFactory.getLogger(EntityProxifier.class);
    private ObjectInstantiator instantiator = ObjectInstantiator.Singleton.INSTANCE.get();
    private ProxyClassFactory factory = ProxyClassFactory.Singleton.INSTANCE.get();

    public <T> Class<T> deriveBaseClass(Object entity) {
        log.debug("Deriving base class for entity {} ", entity);
        Class<?> baseClass = entity.getClass();
        if (this.isProxy(entity)) {
            ProxyInterceptor<Object> interceptor = this.getInterceptor(entity);
            baseClass = interceptor.getTarget().getClass();
        }
        return baseClass;
    }

    public <T> T buildProxyWithAllFieldsLoadedExceptCounters(T entity, EntityOperations context) {
        return this.buildProxy(entity, context, context.getAllGettersExceptCounters());
    }

    public <T> T buildProxyWithNoFieldLoaded(T entity, EntityOperations context) {
        return this.buildProxy(entity, context, new HashSet<Method>());
    }

    public <T> T buildProxy(T entity, EntityOperations context, Set<Method> alreadyLoaded) {
        if (entity == null) {
            return null;
        }
        log.debug("Build Cglib proxy for entity {} ", entity);
        Class<?> proxyClass = this.factory.createProxyClass(entity.getClass(), context.getConfigContext());
        Object instance = this.instantiator.instantiate(proxyClass);
        EntityMeta meta = context.getEntityMeta();
        for (PropertyMeta pm : meta.getAllMetasExceptCounters()) {
            Object value = pm.forValues().getValueFromField(entity);
            pm.forValues().setValueToField(instance, value);
        }
        for (PropertyMeta pm : meta.getAllCounterMetas()) {
            pm.forValues().setValueToField(entity, null);
        }
        ((Factory)instance).setCallbacks(new Callback[]{this.buildInterceptor(context, entity, alreadyLoaded), NoOp.INSTANCE});
        return (T)instance;
    }

    public <T> T getRealObject(T proxy) {
        log.debug("Get real entity from proxy {} ", proxy);
        if (this.isProxy(proxy)) {
            Factory factory = (Factory)proxy;
            ProxyInterceptor interceptor = (ProxyInterceptor)factory.getCallback(0);
            return (T)interceptor.getTarget();
        }
        return proxy;
    }

    public boolean isProxy(Object entity) {
        return Factory.class.isAssignableFrom(entity.getClass());
    }

    public <T> ProxyInterceptor<T> getInterceptor(T proxy) {
        log.debug("Get interceptor from proxy {} ", proxy);
        Factory factory = (Factory)proxy;
        ProxyInterceptor interceptor = (ProxyInterceptor)factory.getCallback(0);
        return interceptor;
    }

    public void ensureProxy(Object proxy) {
        if (!this.isProxy(proxy)) {
            throw new IllegalStateException("The entity '" + proxy + "' is not in 'managed' state.");
        }
    }

    public void ensureNotProxy(Object rawEntity) {
        if (this.isProxy(rawEntity)) {
            throw new IllegalStateException("The entity is already in 'managed' state.");
        }
    }

    public <T> T removeProxy(T proxy) {
        log.debug("Unwrapping object {} ", proxy);
        if (proxy != null) {
            if (this.isProxy(proxy)) {
                return this.getRealObject(proxy);
            }
            return proxy;
        }
        return null;
    }

    public <K, V> Map.Entry<K, V> removeProxy(Map.Entry<K, V> entry) {
        V value = entry.getValue();
        if (this.isProxy(value)) {
            value = this.getRealObject(value);
            entry.setValue(value);
        }
        return entry;
    }

    public <T> Collection<T> removeProxy(Collection<T> proxies) {
        ArrayList<T> result = new ArrayList<T>();
        for (T proxy : proxies) {
            result.add(this.removeProxy(proxy));
        }
        return result;
    }

    public <T> List<T> removeProxy(List<T> proxies) {
        ArrayList<T> result = new ArrayList<T>();
        for (T proxy : proxies) {
            result.add(this.removeProxy(proxy));
        }
        return result;
    }

    public <T> Set<T> removeProxy(Set<T> proxies) {
        HashSet<T> result = new HashSet<T>();
        for (T proxy : proxies) {
            result.add(this.removeProxy(proxy));
        }
        return result;
    }

    public <T> ProxyInterceptor<T> buildInterceptor(EntityOperations context, T entity, Set<Method> alreadyLoaded) {
        return new ProxyInterceptorBuilder<T>(context, entity).alreadyLoaded(alreadyLoaded).build();
    }

    public static enum Singleton {
        INSTANCE;

        private final EntityProxifier instance = new EntityProxifier();

        public EntityProxifier get() {
            return this.instance;
        }
    }
}

