/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.exception.AchillesStaleObjectStateException;
import info.archinnov.achilles.internal.async.AsyncUtils;
import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.persistence.operations.EntityLoader;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.proxy.ProxyInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRefresher {
    private static final Logger log = LoggerFactory.getLogger(EntityRefresher.class);
    private EntityProxifier proxifier = EntityProxifier.Singleton.INSTANCE.get();
    private EntityLoader loader = EntityLoader.Singleton.INSTANCE.get();
    private AsyncUtils asyncUtils = AsyncUtils.Singleton.INSTANCE.get();

    public <T> AchillesFuture<T> refresh(T proxy, EntityOperations context) throws AchillesStaleObjectStateException {
        Object primaryKey = context.getPrimaryKey();
        log.debug("Refreshing entity of class {} and primary key {}", (Object)context.getEntityClass().getCanonicalName(), primaryKey);
        ProxyInterceptor<T> interceptor = this.proxifier.getInterceptor(proxy);
        Object entity = context.getEntity();
        interceptor.getDirtyMap().clear();
        Class entityClass = context.getEntityClass();
        AchillesFuture entityFuture = this.loader.load(context, entityClass);
        Function<T, T> updateInterceptor = this.updateProxyInterceptor(context, interceptor, entity, primaryKey);
        ListenableFuture<T> triggerInterceptors = this.asyncUtils.transformFuture(entityFuture, updateInterceptor, context.getExecutorService());
        return this.asyncUtils.buildInterruptible(triggerInterceptors);
    }

    protected <T> Function<T, T> updateProxyInterceptor(final EntityOperations context, final ProxyInterceptor<T> interceptor, final Object entity, final Object primaryKey) {
        return new Function<T, T>(){

            public T apply(T freshEntity) {
                if (freshEntity == null) {
                    throw new AchillesStaleObjectStateException("The entity '" + entity + "' with primary_key '" + primaryKey + "' no longer exists in Cassandra");
                }
                interceptor.setTarget(freshEntity);
                interceptor.getAlreadyLoaded().clear();
                interceptor.getAlreadyLoaded().addAll(context.getAllGettersExceptCounters());
                return freshEntity;
            }
        };
    }

    public static enum Singleton {
        INSTANCE;

        private final EntityRefresher instance = new EntityRefresher();

        public EntityRefresher get() {
            return this.instance;
        }
    }
}

