/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import info.archinnov.achilles.internal.validation.Validator;

public class NativeQueryValidator {
    public void validateUpsertOrDelete(RegularStatement regularStatement) {
        Validator.validateTrue(this.isUpsertStatement(regularStatement) || this.isDeleteStatement(regularStatement), "The statement '%s' should be an INSERT, an UPDATE or a DELETE", regularStatement.getQueryString());
    }

    public void validateSelect(RegularStatement regularStatement) {
        Validator.validateTrue(this.isSelectStatement(regularStatement), "The statement '%s' should be a SELECT", regularStatement.getQueryString());
    }

    public boolean isSelectStatement(RegularStatement regularStatement) {
        if (this.isSimpleStatement(regularStatement)) {
            return regularStatement.getQueryString().toLowerCase().trim().startsWith("select ");
        }
        return regularStatement instanceof Select || regularStatement instanceof Select.Where;
    }

    public boolean isInsertStatement(RegularStatement regularStatement) {
        if (this.isSimpleStatement(regularStatement)) {
            return regularStatement.getQueryString().toLowerCase().trim().startsWith("insert into ");
        }
        return regularStatement instanceof Insert || regularStatement instanceof Insert.Options;
    }

    public boolean isUpdateStatement(RegularStatement regularStatement) {
        if (this.isSimpleStatement(regularStatement)) {
            return regularStatement.getQueryString().toLowerCase().trim().startsWith("update ");
        }
        return regularStatement instanceof Update.Where || regularStatement instanceof Update.Options;
    }

    public boolean isDeleteStatement(RegularStatement regularStatement) {
        if (this.isSimpleStatement(regularStatement)) {
            return regularStatement.getQueryString().toLowerCase().trim().startsWith("delete ");
        }
        return regularStatement instanceof Delete.Where || regularStatement instanceof Delete.Options;
    }

    public boolean isUpsertStatement(RegularStatement regularStatement) {
        return this.isInsertStatement(regularStatement) || this.isUpdateStatement(regularStatement);
    }

    public boolean isSimpleStatement(RegularStatement regularStatement) {
        return regularStatement instanceof SimpleStatement;
    }

    public static enum Singleton {
        INSTANCE;

        private final NativeQueryValidator instance = new NativeQueryValidator();

        public NativeQueryValidator get() {
            return this.instance;
        }
    }
}

