/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityValidator;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.type.Options;
import java.util.Map;

public class OptionsValidator {
    protected EntityValidator entityValidator = EntityValidator.Singleton.INSTANCE.get();

    public void validateOptionsForUpsert(Object entity, Map<Class<?>, EntityMeta> entityMetaMap, Options options) {
        this.validateNoTtlForClusteredCounter(entity, entityMetaMap, options);
        this.validateNoCasConditionsAndTimestamp(options);
    }

    public void validateNoCasConditionsAndTimestamp(Options options) {
        Validator.validateFalse(options.isIfNotExists() && options.getTimestamp().isPresent(), "Cannot provide custom timestamp for CAS insert operations", new Object[0]);
        Validator.validateFalse(options.hasCASConditions() && options.getTimestamp().isPresent(), "Cannot provide custom timestamp for CAS update operations", new Object[0]);
    }

    public boolean isOptionsValidForBatch(Options options) {
        boolean valid = true;
        if (options.getConsistencyLevel().isPresent() || options.hasAsyncListeners()) {
            valid = false;
        }
        return valid;
    }

    private void validateNoTtlForClusteredCounter(Object entity, Map<Class<?>, EntityMeta> entityMetaMap, Options options) {
        if (options.getTtl().isPresent()) {
            this.entityValidator.validateNotClusteredCounter(entity, entityMetaMap);
        }
    }

    public static enum Singleton {
        INSTANCE;

        private final OptionsValidator instance = new OptionsValidator();

        public OptionsValidator get() {
            return this.instance;
        }
    }
}

