/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import com.datastax.driver.core.Row;
import info.archinnov.achilles.internal.persistence.operations.NativeQueryMapper;
import info.archinnov.achilles.type.TypedMap;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TypedMapIterator
implements Iterator<TypedMap> {
    private final Iterator<Row> sourceIterator;
    NativeQueryMapper mapper = NativeQueryMapper.Singleton.INSTANCE.get();

    public TypedMapIterator(Iterator<Row> sourceIterator) {
        this.sourceIterator = sourceIterator;
    }

    @Override
    public boolean hasNext() {
        return this.sourceIterator.hasNext();
    }

    @Override
    public TypedMap next() {
        if (!this.sourceIterator.hasNext()) {
            throw new NoSuchElementException("No more data. You should call 'hasNext' first to ensure there is remaining data to fetch");
        }
        return this.mapper.mapRow(this.sourceIterator.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove element from a TypedMapIterator");
    }
}

