/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import com.datastax.driver.core.RegularStatement;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.NativeQueryValidator;
import info.archinnov.achilles.internal.validation.Validator;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedQueryValidator {
    private static final Logger log = LoggerFactory.getLogger(TypedQueryValidator.class);
    private static String OPTIONAL_KEYSPACE_PREFIX = "[a-zA-Z0-9_]*\\.?";
    private NativeQueryValidator validator = NativeQueryValidator.Singleton.INSTANCE.get();

    public void validateTypedQuery(Class<?> entityClass, RegularStatement regularStatement, EntityMeta meta) {
        log.debug("Validate typed query {}", (Object)regularStatement.getQueryString());
        PropertyMeta idMeta = meta.getIdMeta();
        String queryString = regularStatement.getQueryString().toLowerCase().trim();
        this.validateRawTypedQuery(entityClass, regularStatement, meta);
        if (!queryString.contains("select *")) {
            idMeta.forTypedQuery().validateTypedQuery(queryString);
        }
    }

    public void validateRawTypedQuery(Class<?> entityClass, RegularStatement regularStatement, EntityMeta meta) {
        log.debug("Validate raw typed query {}", (Object)regularStatement);
        String tableName = meta.config().getTableName().toLowerCase();
        String queryString = regularStatement.getQueryString();
        String normalizedQuery = queryString.toLowerCase();
        this.validator.validateSelect(regularStatement);
        Pattern pattern = Pattern.compile(".* from " + OPTIONAL_KEYSPACE_PREFIX + tableName + "(?: )?.*");
        Validator.validateTrue(pattern.matcher(normalizedQuery).matches(), "The typed query [%s] should contain the table name '%s' if type is '%s'", queryString, tableName, entityClass.getCanonicalName());
    }

    public static enum Singleton {
        INSTANCE;

        private final TypedQueryValidator instance = new TypedQueryValidator();

        public TypedQueryValidator get() {
            return this.instance;
        }
    }
}

