/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.proxy;

import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.CounterLoader;
import info.archinnov.achilles.internal.persistence.operations.EntityLoader;
import info.archinnov.achilles.internal.persistence.operations.InternalCounterBuilder;
import info.archinnov.achilles.internal.proxy.ProxySerializable;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyChecker;
import info.archinnov.achilles.internal.proxy.dirtycheck.SimpleDirtyChecker;
import info.archinnov.achilles.internal.proxy.wrapper.AbstractWrapper;
import info.archinnov.achilles.internal.proxy.wrapper.builder.ListWrapperBuilder;
import info.archinnov.achilles.internal.proxy.wrapper.builder.MapWrapperBuilder;
import info.archinnov.achilles.internal.proxy.wrapper.builder.SetWrapperBuilder;
import info.archinnov.achilles.internal.reflection.ReflectionInvoker;
import info.archinnov.achilles.type.Counter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyInterceptor<T>
implements MethodInterceptor,
ProxySerializable {
    private static final transient Logger log = LoggerFactory.getLogger(ProxyInterceptor.class);
    private transient EntityLoader loader = EntityLoader.Singleton.INSTANCE.get();
    private transient CounterLoader counterLoader = CounterLoader.Singleton.INSTANCE.get();
    private transient ReflectionInvoker invoker = ReflectionInvoker.Singleton.INSTANCE.get();
    private transient T target;
    private transient Object primaryKey;
    private transient Method idGetter;
    private transient Method idSetter;
    private transient Map<Method, PropertyMeta> getterMetas;
    private transient Map<Method, PropertyMeta> setterMetas;
    private transient Map<Method, DirtyChecker> dirtyMap;
    private transient Set<Method> alreadyLoaded;
    private transient EntityOperations context;

    public Object getTarget() {
        return this.target;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        log.trace("Method {} called for entity of class {}", (Object)method.getName(), (Object)this.target.getClass().getCanonicalName());
        if (this.idGetter.equals(method)) {
            return this.primaryKey;
        }
        if (this.idSetter.equals(method)) {
            throw new IllegalAccessException("Cannot change primary key value for existing entity ");
        }
        Object result = null;
        if (this.getterMetas.containsKey(method)) {
            result = this.interceptGetter(method);
        } else if (this.setterMetas.containsKey(method)) {
            this.interceptSetter(method, obj, args);
        } else {
            result = proxy.invoke(this.target, args);
        }
        return result;
    }

    private Object interceptGetter(Method method) throws Throwable {
        AbstractWrapper result = null;
        PropertyMeta propertyMeta = this.getterMetas.get(method);
        if (!this.alreadyLoaded.contains(method)) {
            log.trace("Loading property {}", (Object)propertyMeta.getPropertyName());
            if (this.context.isClusteredCounter()) {
                this.counterLoader.loadClusteredCounterColumn(this.context, this.target, propertyMeta);
            } else {
                this.loader.loadPropertyIntoObject(this.context, this.target, propertyMeta);
            }
            this.alreadyLoaded.add(method);
        }
        log.trace("Get value from field {} on real object", (Object)propertyMeta.getPropertyName());
        Object rawValue = this.invoker.getValueFromField(this.target, propertyMeta.getField());
        switch (propertyMeta.type()) {
            case COUNTER: {
                if (rawValue == null) {
                    Counter counter = InternalCounterBuilder.initialValue(null);
                    propertyMeta.forValues().setValueToField(this.target, counter);
                }
                result = (AbstractWrapper)rawValue;
                break;
            }
            case LIST: {
                if (rawValue == null) break;
                log.trace("Build list wrapper for property {} of entity of class {} ", (Object)propertyMeta.getPropertyName(), (Object)propertyMeta.getEntityClassName());
                List list = (List)rawValue;
                result = ((ListWrapperBuilder)((ListWrapperBuilder)((ListWrapperBuilder)ListWrapperBuilder.builder(list).dirtyMap(this.dirtyMap)).setter(propertyMeta.getSetter())).propertyMeta(this.getPropertyMetaByProperty(method))).build();
                break;
            }
            case SET: {
                if (rawValue == null) break;
                log.trace("Build set wrapper for property {} of entity of class {} ", (Object)propertyMeta.getPropertyName(), (Object)propertyMeta.getEntityClassName());
                Set set = (Set)rawValue;
                result = ((SetWrapperBuilder)((SetWrapperBuilder)((SetWrapperBuilder)SetWrapperBuilder.builder(set).dirtyMap(this.dirtyMap)).setter(propertyMeta.getSetter())).propertyMeta(this.getPropertyMetaByProperty(method))).build();
                break;
            }
            case MAP: {
                if (rawValue == null) break;
                log.trace("Build map wrapper for property {} of entity of class {} ", (Object)propertyMeta.getPropertyName(), (Object)propertyMeta.getEntityClassName());
                Map map = (Map)rawValue;
                result = ((MapWrapperBuilder)((MapWrapperBuilder)((MapWrapperBuilder)MapWrapperBuilder.builder(map).dirtyMap(this.dirtyMap)).setter(propertyMeta.getSetter())).propertyMeta(this.getPropertyMetaByProperty(method))).build();
                break;
            }
            default: {
                log.trace("Return un-mapped raw value {} for property {} of entity of class {} ", (Object)propertyMeta.getPropertyName(), (Object)propertyMeta.getEntityClassName());
                result = (AbstractWrapper)rawValue;
            }
        }
        return result;
    }

    private void interceptSetter(Method method, Object obj, Object[] args) throws Throwable {
        PropertyMeta propertyMeta = this.setterMetas.get(method);
        DirtyChecker dirtyChecker = null;
        boolean removeField = false;
        if (args[0] == null) {
            removeField = true;
        }
        switch (propertyMeta.type()) {
            case SIMPLE: {
                dirtyChecker = new SimpleDirtyChecker(propertyMeta);
                break;
            }
            case SET: {
                dirtyChecker = new DirtyChecker(propertyMeta);
                if (removeField) {
                    dirtyChecker.removeAllElements();
                    break;
                }
                dirtyChecker.assignValue((Set)args[0]);
                break;
            }
            case LIST: {
                dirtyChecker = new DirtyChecker(propertyMeta);
                if (removeField) {
                    dirtyChecker.removeAllElements();
                    break;
                }
                dirtyChecker.assignValue((List)args[0]);
                break;
            }
            case MAP: {
                dirtyChecker = new DirtyChecker(propertyMeta);
                if (removeField) {
                    dirtyChecker.removeAllElements();
                    break;
                }
                dirtyChecker.assignValue((Map)args[0]);
                break;
            }
            case COUNTER: {
                throw new UnsupportedOperationException("Cannot set value directly to a Counter type. Please call the getter first to get handle on the wrapper");
            }
        }
        log.trace("Flagging property {}", (Object)propertyMeta.getPropertyName());
        this.dirtyMap.put(method, dirtyChecker);
        Object value = null;
        if (args.length > 0) {
            value = args[0];
        }
        propertyMeta.forValues().setValueToField(this.target, value);
    }

    @Override
    public Object writeReplace() {
        return this.target;
    }

    public Map<Method, DirtyChecker> getDirtyMap() {
        return this.dirtyMap;
    }

    public Set<Method> getAlreadyLoaded() {
        return this.alreadyLoaded;
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public void setTarget(T target) {
        this.target = target;
    }

    void setPrimaryKey(Object key) {
        this.primaryKey = key;
    }

    void setIdGetter(Method idGetter) {
        this.idGetter = idGetter;
    }

    void setIdSetter(Method idSetter) {
        this.idSetter = idSetter;
    }

    void setGetterMetas(Map<Method, PropertyMeta> getterMetas) {
        this.getterMetas = getterMetas;
    }

    void setSetterMetas(Map<Method, PropertyMeta> setterMetas) {
        this.setterMetas = setterMetas;
    }

    void setDirtyMap(Map<Method, DirtyChecker> dirtyMap) {
        this.dirtyMap = dirtyMap;
    }

    void setAlreadyLoaded(Set<Method> lazyLoaded) {
        this.alreadyLoaded = lazyLoaded;
    }

    public EntityOperations getEntityOperations() {
        return this.context;
    }

    public void setEntityOperations(EntityOperations context) {
        this.context = context;
    }

    private PropertyMeta getPropertyMetaByProperty(Method method) {
        return this.getterMetas.get(method);
    }
}

