/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.proxy.wrapper;

import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyChecker;
import info.archinnov.achilles.internal.proxy.wrapper.AbstractWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapWrapper
extends AbstractWrapper
implements Map<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(MapWrapper.class);
    private final Map<Object, Object> target;

    public MapWrapper(Map<Object, Object> target) {
        this.target = target;
    }

    @Override
    public void clear() {
        if (this.target.size() > 0) {
            log.trace("Mark map property {} of entity class {} dirty upon all elements clearance", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
            this.getDirtyChecker().removeAllElements();
        }
        this.target.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.target.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.target.containsValue(this.proxifier.removeProxy(value));
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return new HashSet<Map.Entry<Object, Object>>(this.target.entrySet());
    }

    @Override
    public Object get(Object key) {
        if (log.isTraceEnabled()) {
            log.trace("Return value having key{} for map property {} of entity class {}", new Object[]{key, this.propertyMeta.getPropertyName(), this.propertyMeta.getEntityClassName()});
        }
        return this.target.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.target.isEmpty();
    }

    @Override
    public Set<Object> keySet() {
        return new HashSet<Object>(this.target.keySet());
    }

    @Override
    public Object put(Object key, Object value) {
        log.trace("Mark map property {} of entity class {} dirty upon new value {} addition for key {}", new Object[]{this.propertyMeta.getPropertyName(), this.propertyMeta.getEntityClassName(), value, key});
        Object element = this.proxifier.removeProxy(value);
        Object result = this.target.put(key, element);
        HashMap<Object, Object> entries = new HashMap<Object, Object>();
        entries.put(key, value);
        this.getDirtyChecker().addElements(entries);
        return result;
    }

    @Override
    public void putAll(Map<?, ?> map) {
        HashMap<Object, Object> encodedMap = new HashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object element = this.proxifier.removeProxy(entry.getValue());
            Object key = entry.getKey();
            encodedMap.put(key, element);
        }
        if (encodedMap.size() > 0) {
            this.getDirtyChecker().addElements(encodedMap);
        }
        log.trace("Mark encodedMap property {} of entity class {} dirty upon new key/value pairs addition", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        this.target.putAll(encodedMap);
    }

    @Override
    public Object remove(Object key) {
        Object element = this.proxifier.removeProxy(key);
        if (this.target.containsKey(element)) {
            log.trace("Mark map property {} of entity class {} dirty upon removal of value havo,g key {}", new Object[]{this.propertyMeta.getPropertyName(), this.propertyMeta.getEntityClassName(), key});
            this.getDirtyChecker().removeMapEntry(key);
        }
        return this.target.remove(element);
    }

    @Override
    public int size() {
        return this.target.size();
    }

    @Override
    public Collection<Object> values() {
        return new ArrayList<Object>(this.target.values());
    }

    public Map<Object, Object> getTarget() {
        return this.target;
    }

    @Override
    protected DirtyChecker getDirtyChecker() {
        if (!this.dirtyMap.containsKey(this.setter)) {
            this.dirtyMap.put(this.setter, new DirtyChecker(this.propertyMeta));
        }
        return (DirtyChecker)this.dirtyMap.get(this.setter);
    }
}

