/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.proxy.wrapper;

import com.google.common.collect.Sets;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyChecker;
import info.archinnov.achilles.internal.proxy.wrapper.AbstractWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetWrapper
extends AbstractWrapper
implements Set<Object> {
    private static final Logger log = LoggerFactory.getLogger(SetWrapper.class);
    private Set<Object> target;

    public SetWrapper(Set<Object> target) {
        this.target = target;
    }

    @Override
    public boolean add(Object arg0) {
        log.trace("Mark set property {} of entity class {} dirty upon element addition", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        Object element = this.proxifier.removeProxy(arg0);
        boolean added = this.target.add(element);
        if (added) {
            this.getDirtyChecker().addElements(Sets.newHashSet((Object[])new Object[]{arg0}));
        }
        return added;
    }

    @Override
    public boolean addAll(Collection<?> arg0) {
        Collection<?> elements = this.proxifier.removeProxy(arg0);
        boolean added = this.target.addAll(elements);
        if (added) {
            log.trace("Mark set property {} of entity class {} dirty upon elements addition", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
            this.getDirtyChecker().addElements(Sets.newHashSet(elements));
        }
        return added;
    }

    @Override
    public void clear() {
        if (this.target.size() > 0) {
            log.trace("Mark set property {} of entity class {} dirty upon clearance", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
            this.getDirtyChecker().removeAllElements();
        }
        this.target.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.target.contains(this.proxifier.removeProxy(arg0));
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.target.containsAll(this.proxifier.removeProxy(arg0));
    }

    @Override
    public boolean isEmpty() {
        return this.target.isEmpty();
    }

    @Override
    public Iterator<Object> iterator() {
        log.trace("Build iterator wrapper for set property {} of entity class {}", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        return new ArrayList<Object>(this.target).iterator();
    }

    @Override
    public boolean remove(Object arg0) {
        Object element = this.proxifier.removeProxy(arg0);
        boolean result = this.target.remove(element);
        if (result) {
            log.trace("Mark set property {} of entity class {} dirty upon element removal", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
            this.getDirtyChecker().removeElements(Sets.newHashSet((Object[])new Object[]{element}));
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        Collection<?> elements = this.proxifier.removeProxy(arg0);
        boolean result = this.target.removeAll(elements);
        if (result) {
            log.trace("Mark set property {} of entity class {} dirty upon elements removal", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
            this.getDirtyChecker().removeElements(Sets.newHashSet(elements));
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        Collection<?> elements = this.proxifier.removeProxy(arg0);
        HashSet<Object> originalSet = new HashSet<Object>(this.target);
        boolean result = this.target.retainAll(elements);
        if (result) {
            log.trace("Mark set property {} of entity class {} dirty upon elements retentions", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
            Sets.SetView intersection = Sets.intersection(originalSet, new HashSet(arg0));
            Sets.SetView difference = Sets.difference(originalSet, (Set)intersection);
            if (difference.size() > 0) {
                this.getDirtyChecker().removeElements((Set<Object>)difference);
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.target.size();
    }

    @Override
    public Object[] toArray() {
        return this.target.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.target.toArray(arg0);
    }

    public Collection<Object> getTarget() {
        return this.target;
    }

    @Override
    protected DirtyChecker getDirtyChecker() {
        if (!this.dirtyMap.containsKey(this.setter)) {
            this.dirtyMap.put(this.setter, new DirtyChecker(this.propertyMeta));
        }
        return (DirtyChecker)this.dirtyMap.get(this.setter);
    }
}

