/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement;

import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import com.google.common.base.Optional;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.context.facade.PersistentStateHolder;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.EntityMetaConfig;
import info.archinnov.achilles.internal.persistence.operations.CollectionAndMapChangeType;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyCheckChangeSet;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.Pair;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementGenerator {
    private static final Logger log = LoggerFactory.getLogger(StatementGenerator.class);

    public Pair<Update.Where, Object[]> generateCollectionAndMapUpdateOperation(PersistentStateHolder context, DirtyCheckChangeSet changeSet) {
        Pair<Update.Assignments, Object[]> updateClauseAndBoundValues;
        log.trace("Generate collection/map update operation for dirty change set {}", (Object)changeSet);
        Object entity = context.getEntity();
        EntityMeta meta = context.getEntityMeta();
        EntityMetaConfig metaConfig = meta.config();
        Optional<Integer> ttlO = context.getTtl();
        Optional<Long> timestampO = context.getTimestamp();
        List<Options.CASCondition> CASConditions = context.getCasConditions();
        Update.Conditions conditions = QueryBuilder.update((String)metaConfig.getKeyspaceName(), (String)metaConfig.getTableName()).onlyIf();
        List<Object> casEncodedValues = this.addAndEncodeCasConditions(meta, CASConditions, conditions);
        Object[] boundValues = new Object[]{};
        if (ttlO.isPresent()) {
            conditions.using(QueryBuilder.ttl((int)((Integer)ttlO.get())));
            boundValues = ArrayUtils.addAll((Object[])boundValues, (Object[])new Object[]{ttlO.get()});
        }
        if (timestampO.isPresent()) {
            conditions.using(QueryBuilder.timestamp((long)((Long)timestampO.get())));
            boundValues = ArrayUtils.addAll((Object[])boundValues, (Object[])new Object[]{timestampO.get()});
        }
        CollectionAndMapChangeType operationType = changeSet.getChangeType();
        switch (operationType) {
            case SET_TO_LIST_AT_INDEX: {
                updateClauseAndBoundValues = changeSet.generateUpdateForSetAtIndexElement(conditions);
                break;
            }
            case REMOVE_FROM_LIST_AT_INDEX: {
                updateClauseAndBoundValues = changeSet.generateUpdateForRemovedAtIndexElement(conditions);
                break;
            }
            default: {
                throw new AchillesException(String.format("Should not generate non-prepared statement for collection/map change of type '%s'", new Object[]{operationType}));
            }
        }
        Pair<Update.Where, Object[]> whereClauseAndBoundValues = meta.getIdMeta().forStatementGeneration().generateWhereClauseForUpdate(entity, changeSet.getPropertyMeta(), (Update.Assignments)updateClauseAndBoundValues.left);
        boundValues = ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])boundValues, (Object[])ArrayUtils.addAll((Object[])((Object[])updateClauseAndBoundValues.right), (Object[])((Object[])whereClauseAndBoundValues.right))), (Object[])casEncodedValues.toArray());
        return Pair.create(whereClauseAndBoundValues.left, boundValues);
    }

    private List<Object> addAndEncodeCasConditions(EntityMeta entityMeta, List<Options.CASCondition> CASConditions, Update.Conditions conditions) {
        ArrayList<Object> casEncodedValues = new ArrayList<Object>();
        for (Options.CASCondition casCondition : CASConditions) {
            Object encodedValue = entityMeta.forTranscoding().encodeCasConditionValue(casCondition);
            casEncodedValues.add(encodedValue);
            conditions.and(casCondition.toClause());
        }
        return casEncodedValues;
    }

    public static enum Singleton {
        INSTANCE;

        private final StatementGenerator instance = new StatementGenerator();

        public StatementGenerator get() {
            return this.instance;
        }
    }
}

