/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.cache;

import com.google.common.base.Optional;
import info.archinnov.achilles.internal.statement.cache.CacheType;
import info.archinnov.achilles.query.slice.SliceQueryProperties;
import info.archinnov.achilles.type.Options;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class StatementCacheKey {
    private CacheType type;
    private Set<String> fields = new LinkedHashSet<String>();
    private Class<?> entityClass;
    private OptionsCacheKey optionsCacheKey;
    private Optional<SliceQueryProperties> sliceQueryPropertiesO = Optional.absent();

    public StatementCacheKey(CacheType type, Set<String> fields, Class<?> entityClass, Options options) {
        this.type = type;
        this.entityClass = entityClass;
        this.fields = fields;
        this.optionsCacheKey = OptionsCacheKey.fromOptions(options);
    }

    public StatementCacheKey(CacheType type, SliceQueryProperties sliceQueryProperties) {
        this.type = type;
        this.entityClass = sliceQueryProperties.getEntityMeta().getEntityClass();
        this.sliceQueryPropertiesO = Optional.fromNullable((Object)sliceQueryProperties);
    }

    public CacheType getType() {
        return this.type;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public <T> Class<T> getEntityClass() {
        return this.entityClass;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entityClass, this.fields, this.type, this.optionsCacheKey, this.sliceQueryPropertiesO});
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        StatementCacheKey other = (StatementCacheKey)o;
        return Objects.equals(this.entityClass, other.entityClass) && Objects.equals(this.fields, other.fields) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.optionsCacheKey, other.optionsCacheKey) && Objects.equals(this.sliceQueryPropertiesO, other.sliceQueryPropertiesO);
    }

    public String toString() {
        return "StatementCacheKey{type=" + Objects.toString((Object)this.type) + ", fields=" + Objects.toString(this.fields) + ", entityClass=" + Objects.toString(this.entityClass) + ", optionsCacheKey=" + Objects.toString(this.optionsCacheKey) + '}';
    }

    private static class OptionsCacheKey {
        private boolean hasTimestamp;
        private boolean ifNotExists;
        private List<Options.CASCondition> CASConditions;

        private OptionsCacheKey(boolean hasTimestamp, boolean ifNotExists, List<Options.CASCondition> CASConditions) {
            this.hasTimestamp = hasTimestamp;
            this.ifNotExists = ifNotExists;
            this.CASConditions = CASConditions;
        }

        private static OptionsCacheKey fromOptions(Options options) {
            boolean hasTimestamp = options.getTimestamp().isPresent();
            boolean ifNotExists = options.isIfNotExists();
            List CASConditions = (List)Optional.fromNullable(options.getCASConditions()).or(Collections.emptyList());
            return new OptionsCacheKey(hasTimestamp, ifNotExists, CASConditions);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            OptionsCacheKey other = (OptionsCacheKey)o;
            return Objects.equals(this.hasTimestamp, other.hasTimestamp) && Objects.equals(this.ifNotExists, other.ifNotExists) && Objects.equals(this.CASConditions, other.CASConditions);
        }

        public int hashCode() {
            return Objects.hash(this.hasTimestamp, this.ifNotExists, this.CASConditions);
        }

        public String toString() {
            return "OptionsCacheKey{hasTimestamp=" + Objects.toString(this.hasTimestamp) + ", ifNotExists=" + Objects.toString(this.ifNotExists) + ", CASConditions=" + Objects.toString(this.CASConditions) + '}';
        }
    }
}

