/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.prepared;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import info.archinnov.achilles.counter.AchillesCounter;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.EntityMetaConfig;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaStatementGenerator;
import info.archinnov.achilles.internal.persistence.operations.CollectionAndMapChangeType;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyCheckChangeSet;
import info.archinnov.achilles.query.slice.SliceQueryProperties;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.OptionsBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementGenerator {
    private static final Logger log = LoggerFactory.getLogger(PreparedStatementGenerator.class);

    public PreparedStatement prepareInsert(Session session, EntityMeta entityMeta, List<PropertyMeta> pms, Options options) {
        log.trace("Generate prepared statement for INSERT on {}", (Object)entityMeta);
        PropertyMeta idMeta = entityMeta.getIdMeta();
        EntityMetaConfig metaConfig = entityMeta.config();
        Insert insert = QueryBuilder.insertInto((String)metaConfig.getKeyspaceName(), (String)metaConfig.getTableName());
        if (options.isIfNotExists()) {
            insert.ifNotExists();
        }
        idMeta.forStatementGeneration().generateInsertPrimaryKey(insert);
        for (PropertyMeta pm : pms) {
            String cql3ColumnName = pm.getCQL3ColumnName();
            insert.value(cql3ColumnName, (Object)QueryBuilder.bindMarker((String)cql3ColumnName));
        }
        Insert.Options insertOptions = insert.using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl")));
        if (options.getTimestamp().isPresent()) {
            insertOptions.and(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker((String)"timestamp")));
        }
        return session.prepare(insert.getQueryString());
    }

    public PreparedStatement prepareSelectField(Session session, EntityMeta entityMeta, PropertyMeta pm) {
        log.trace("Generate prepared statement for SELECT property {}", (Object)pm);
        PropertyMeta idMeta = entityMeta.getIdMeta();
        if (pm.structure().isCounter()) {
            throw new IllegalArgumentException(String.format("Cannot prepare statement for property '%s' of entity '%s' because it is a counter type", pm.getPropertyName(), entityMeta.getClassName()));
        }
        Select.Selection select = pm.forStatementGeneration().prepareSelectField(QueryBuilder.select());
        EntityMetaConfig metaConfig = entityMeta.config();
        Select from = select.from(metaConfig.getKeyspaceName(), metaConfig.getTableName());
        RegularStatement statement = idMeta.forStatementGeneration().generateWhereClauseForSelect((Optional<PropertyMeta>)Optional.fromNullable((Object)pm), from);
        return session.prepare(statement.getQueryString());
    }

    public PreparedStatement prepareUpdateFields(Session session, EntityMeta entityMeta, List<PropertyMeta> pms, Options options) {
        log.trace("Generate prepared statement for UPDATE properties {}", pms);
        PropertyMeta idMeta = entityMeta.getIdMeta();
        EntityMetaConfig metaConfig = entityMeta.config();
        Update update = QueryBuilder.update((String)metaConfig.getKeyspaceName(), (String)metaConfig.getTableName());
        Update.Conditions updateConditions = update.onlyIf();
        if (options.hasCASConditions()) {
            for (Options.CASCondition CASCondition2 : options.getCASConditions()) {
                updateConditions.and(CASCondition2.toClauseForPreparedStatement());
            }
        }
        Update.Assignments assignments = null;
        boolean onlyStaticColumns = true;
        for (int i = 0; i < pms.size(); ++i) {
            PropertyMeta pm = pms.get(i);
            if (!pm.structure().isStaticColumn()) {
                onlyStaticColumns = false;
            }
            assignments = i == 0 ? pm.forStatementGeneration().prepareUpdateField(updateConditions) : pm.forStatementGeneration().prepareUpdateField(assignments);
        }
        RegularStatement statement = this.prepareWhereClauseWithTTLForUpdate(idMeta, assignments, onlyStaticColumns, options);
        return session.prepare(statement.getQueryString());
    }

    public PreparedStatement prepareSelectAll(Session session, EntityMeta entityMeta) {
        log.trace("Generate prepared statement for SELECT of {}", (Object)entityMeta);
        PropertyMeta idMeta = entityMeta.getIdMeta();
        EntityMetaConfig metaConfig = entityMeta.config();
        Select.Selection select = QueryBuilder.select();
        for (PropertyMeta pm : entityMeta.forOperations().getColumnsMetaToLoad()) {
            select = pm.forStatementGeneration().prepareSelectField(select);
        }
        Select from = select.from(metaConfig.getKeyspaceName(), metaConfig.getTableName());
        Optional staticMeta = Optional.absent();
        if (entityMeta.structure().hasOnlyStaticColumns()) {
            staticMeta = Optional.fromNullable((Object)entityMeta.getAllMetasExceptId().get(0));
        }
        RegularStatement statement = idMeta.forStatementGeneration().generateWhereClauseForSelect((Optional<PropertyMeta>)staticMeta, from);
        return session.prepare(statement.getQueryString());
    }

    public Map<AchillesCounter.CQLQueryType, PreparedStatement> prepareSimpleCounterQueryMap(Session session) {
        String incr = QueryBuilder.update((String)"achilles_counter_table").with(QueryBuilder.incr((String)"counter_value", (BindMarker)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"fqcn", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"primary_key", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"property_name", (Object)QueryBuilder.bindMarker())).getQueryString();
        String decr = QueryBuilder.update((String)"achilles_counter_table").with(QueryBuilder.decr((String)"counter_value", (BindMarker)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"fqcn", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"primary_key", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"property_name", (Object)QueryBuilder.bindMarker())).getQueryString();
        String select = QueryBuilder.select((String[])new String[]{"counter_value"}).from("achilles_counter_table").where(QueryBuilder.eq((String)"fqcn", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"primary_key", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"property_name", (Object)QueryBuilder.bindMarker())).getQueryString();
        String delete = QueryBuilder.delete().from("achilles_counter_table").where(QueryBuilder.eq((String)"fqcn", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"primary_key", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"property_name", (Object)QueryBuilder.bindMarker())).getQueryString();
        HashMap<AchillesCounter.CQLQueryType, PreparedStatement> counterPSMap = new HashMap<AchillesCounter.CQLQueryType, PreparedStatement>();
        counterPSMap.put(AchillesCounter.CQLQueryType.INCR, session.prepare(incr));
        counterPSMap.put(AchillesCounter.CQLQueryType.DECR, session.prepare(decr));
        counterPSMap.put(AchillesCounter.CQLQueryType.SELECT, session.prepare(select));
        counterPSMap.put(AchillesCounter.CQLQueryType.DELETE, session.prepare(delete));
        return counterPSMap;
    }

    public Map<AchillesCounter.CQLQueryType, Map<String, PreparedStatement>> prepareClusteredCounterQueryMap(Session session, EntityMeta meta) {
        PropertyMeta idMeta = meta.getIdMeta();
        EntityMetaConfig metaConfig = meta.config();
        String keyspaceName = metaConfig.getKeyspaceName();
        String tableName = metaConfig.getTableName();
        HashMap<AchillesCounter.CQLQueryType, Map<String, PreparedStatement>> clusteredCounterPSMap = new HashMap<AchillesCounter.CQLQueryType, Map<String, PreparedStatement>>();
        HashMap<String, PreparedStatement> incrStatementPerCounter = new HashMap<String, PreparedStatement>();
        HashMap<String, PreparedStatement> decrStatementPerCounter = new HashMap<String, PreparedStatement>();
        HashMap<String, PreparedStatement> selectStatementPerCounter = new HashMap<String, PreparedStatement>();
        PropertyMetaStatementGenerator statementGenerator = idMeta.forStatementGeneration();
        for (PropertyMeta counterMeta : meta.getAllCounterMetas()) {
            String propertyName = counterMeta.getPropertyName();
            String cql3ColumnName = counterMeta.getCQL3ColumnName();
            boolean staticColumn = counterMeta.structure().isStaticColumn();
            RegularStatement incrementStatement = this.prepareWhereClauseForCounterUpdate(statementGenerator, QueryBuilder.update((String)keyspaceName, (String)tableName).with(QueryBuilder.incr((String)cql3ColumnName, (BindMarker)QueryBuilder.bindMarker((String)cql3ColumnName))), staticColumn, OptionsBuilder.noOptions());
            RegularStatement decrementStatement = this.prepareWhereClauseForCounterUpdate(statementGenerator, QueryBuilder.update((String)keyspaceName, (String)tableName).with(QueryBuilder.decr((String)cql3ColumnName, (BindMarker)QueryBuilder.bindMarker((String)cql3ColumnName))), staticColumn, OptionsBuilder.noOptions());
            RegularStatement selectStatement = statementGenerator.generateWhereClauseForSelect((Optional<PropertyMeta>)Optional.fromNullable((Object)counterMeta), QueryBuilder.select((String[])new String[]{cql3ColumnName}).from(keyspaceName, tableName));
            incrStatementPerCounter.put(propertyName, session.prepare(incrementStatement));
            decrStatementPerCounter.put(propertyName, session.prepare(decrementStatement));
            selectStatementPerCounter.put(propertyName, session.prepare(selectStatement));
        }
        clusteredCounterPSMap.put(AchillesCounter.CQLQueryType.INCR, incrStatementPerCounter);
        clusteredCounterPSMap.put(AchillesCounter.CQLQueryType.DECR, decrStatementPerCounter);
        RegularStatement selectStatement = statementGenerator.generateWhereClauseForSelect((Optional<PropertyMeta>)Optional.absent(), QueryBuilder.select().from(keyspaceName, tableName));
        selectStatementPerCounter.put(AchillesCounter.ClusteredCounterStatement.SELECT_ALL.name(), session.prepare(selectStatement));
        clusteredCounterPSMap.put(AchillesCounter.CQLQueryType.SELECT, selectStatementPerCounter);
        RegularStatement deleteStatement = statementGenerator.generateWhereClauseForDelete(false, QueryBuilder.delete().from(keyspaceName, tableName));
        clusteredCounterPSMap.put(AchillesCounter.CQLQueryType.DELETE, (Map<String, PreparedStatement>)ImmutableMap.of((Object)AchillesCounter.ClusteredCounterStatement.DELETE_ALL.name(), (Object)session.prepare(deleteStatement)));
        return clusteredCounterPSMap;
    }

    private RegularStatement prepareWhereClauseWithTTLForUpdate(PropertyMeta idMeta, Update.Assignments assignments, boolean onlyStaticColumns, Options options) {
        Update.Where where = idMeta.forStatementGeneration().prepareCommonWhereClauseForUpdate(assignments, onlyStaticColumns);
        Update.Options updateOptions = where.using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl")));
        if (options.getTimestamp().isPresent()) {
            updateOptions.and(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker((String)"timestamp")));
        }
        return updateOptions;
    }

    private RegularStatement prepareWhereClauseForCounterUpdate(PropertyMetaStatementGenerator statementGenerator, Update.Assignments assignments, boolean onlyStaticColumns, Options options) {
        Update.Where where = statementGenerator.prepareCommonWhereClauseForUpdate(assignments, onlyStaticColumns);
        if (options.getTimestamp().isPresent()) {
            return where.using(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker((String)"timestamp")));
        }
        return where;
    }

    public Map<String, PreparedStatement> prepareDeletePSs(Session session, EntityMeta entityMeta) {
        log.trace("Generate prepared statement for DELETE of {}", (Object)entityMeta);
        PropertyMeta idMeta = entityMeta.getIdMeta();
        EntityMetaConfig metaConfig = entityMeta.config();
        HashMap<String, PreparedStatement> deletePSs = new HashMap<String, PreparedStatement>();
        Delete mainFrom = QueryBuilder.delete().from(metaConfig.getKeyspaceName(), metaConfig.getTableName());
        RegularStatement mainStatement = idMeta.forStatementGeneration().generateWhereClauseForDelete(entityMeta.structure().hasOnlyStaticColumns(), mainFrom);
        deletePSs.put(metaConfig.getQualifiedTableName(), session.prepare(mainStatement.getQueryString()));
        return deletePSs;
    }

    public PreparedStatement prepareCollectionAndMapUpdate(Session session, EntityMeta meta, DirtyCheckChangeSet changeSet, Options options) {
        EntityMetaConfig metaConfig = meta.config();
        Update.Conditions conditions = QueryBuilder.update((String)metaConfig.getKeyspaceName(), (String)metaConfig.getTableName()).onlyIf();
        if (options.hasCASConditions()) {
            for (Options.CASCondition CASCondition2 : options.getCASConditions()) {
                conditions.and(CASCondition2.toClauseForPreparedStatement());
            }
        }
        CollectionAndMapChangeType changeType = changeSet.getChangeType();
        Update.Assignments assignments = null;
        switch (changeType) {
            case ASSIGN_VALUE_TO_LIST: 
            case ASSIGN_VALUE_TO_SET: 
            case ASSIGN_VALUE_TO_MAP: 
            case REMOVE_COLLECTION_OR_MAP: {
                assignments = changeSet.generateUpdateForRemoveAll(conditions);
                break;
            }
            case ADD_TO_SET: {
                assignments = changeSet.generateUpdateForAddedElements(conditions);
                break;
            }
            case REMOVE_FROM_SET: {
                assignments = changeSet.generateUpdateForRemovedElements(conditions);
                break;
            }
            case APPEND_TO_LIST: {
                assignments = changeSet.generateUpdateForAppendedElements(conditions);
                break;
            }
            case PREPEND_TO_LIST: {
                assignments = changeSet.generateUpdateForPrependedElements(conditions);
                break;
            }
            case REMOVE_FROM_LIST: {
                assignments = changeSet.generateUpdateForRemoveListElements(conditions);
                break;
            }
            case SET_TO_LIST_AT_INDEX: {
                throw new IllegalStateException("Cannot prepare statement to set element at index for list");
            }
            case REMOVE_FROM_LIST_AT_INDEX: {
                throw new IllegalStateException("Cannot prepare statement to remove element at index for list");
            }
            case ADD_TO_MAP: {
                assignments = changeSet.generateUpdateForAddedEntries(conditions);
                break;
            }
            case REMOVE_FROM_MAP: {
                assignments = changeSet.generateUpdateForRemovedKey(conditions);
            }
        }
        RegularStatement regularStatement = this.prepareWhereClauseWithTTLForUpdate(meta.getIdMeta(), assignments, changeSet.getPropertyMeta().structure().isStaticColumn(), options);
        PreparedStatement preparedStatement = session.prepare(regularStatement);
        return preparedStatement;
    }

    public PreparedStatement prepareSelectSliceQuery(Session session, SliceQueryProperties<?> sliceQueryProperties) {
        log.trace("Generate SELECT statement for slice query");
        EntityMeta entityMeta = sliceQueryProperties.getEntityMeta();
        EntityMetaConfig metaConfig = entityMeta.config();
        Select.Selection select = QueryBuilder.select();
        for (PropertyMeta pm : entityMeta.forOperations().getColumnsMetaToLoad()) {
            select = pm.forStatementGeneration().prepareSelectField(select);
        }
        Select from = select.from(metaConfig.getKeyspaceName(), metaConfig.getTableName());
        RegularStatement whereClause = sliceQueryProperties.generateWhereClauseForSelect(from);
        return session.prepare(whereClause.getQueryString());
    }

    public PreparedStatement prepareDeleteSliceQuery(Session session, SliceQueryProperties<?> sliceQueryProperties) {
        log.trace("Generate DELETE statement for slice query");
        EntityMetaConfig metaConfig = sliceQueryProperties.getEntityMeta().config();
        Delete delete = QueryBuilder.delete().from(metaConfig.getKeyspaceName(), metaConfig.getTableName());
        Delete.Where whereClause = sliceQueryProperties.generateWhereClauseForDelete(delete);
        return session.prepare(whereClause.getQueryString());
    }

    public static enum Singleton {
        INSTANCE;

        private final PreparedStatementGenerator instance = new PreparedStatementGenerator();

        public PreparedStatementGenerator get() {
            return this.instance;
        }
    }
}

