/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.wrapper;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.TraceRetrievalException;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.exception.AchillesLightWeightTransactionException;
import info.archinnov.achilles.internal.async.AsyncUtils;
import info.archinnov.achilles.internal.reflection.RowMethodInvoker;
import info.archinnov.achilles.listener.CASResultListener;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.TypedMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatementWrapper {
    public static final EventComparator EVENT_TRACE_COMPARATOR = new EventComparator();
    public static final String ACHILLES_DML_STATEMENT = "ACHILLES_DML_STATEMENT";
    protected static final String IF_NOT_EXIST_CLAUSE = " IF NOT EXISTS";
    protected static final String IF_CLAUSE = " IF ";
    protected static final String CAS_RESULT_COLUMN = "[applied]";
    protected static final Logger dmlLogger = LoggerFactory.getLogger((String)"ACHILLES_DML_STATEMENT");
    protected RowMethodInvoker invoker = RowMethodInvoker.Singleton.INSTANCE.get();
    protected AsyncUtils asyncUtils = AsyncUtils.Singleton.INSTANCE.get();
    protected Optional<CASResultListener> casResultListener = Optional.absent();
    protected Object[] values = new Object[0];
    protected boolean traceQueryForEntity = false;
    protected boolean displayDMLForEntity = false;
    protected Logger entityLogger;

    protected AbstractStatementWrapper(Class<?> entityClass, Object[] values) {
        if (ArrayUtils.isNotEmpty((Object[])values)) {
            this.values = values;
        }
        if (entityClass != null && LoggerFactory.getLogger(entityClass) != null) {
            this.traceQueryForEntity = LoggerFactory.getLogger(entityClass).isTraceEnabled();
            this.displayDMLForEntity = LoggerFactory.getLogger(entityClass).isDebugEnabled();
            this.entityLogger = LoggerFactory.getLogger(entityClass);
        }
    }

    public Object[] getValues() {
        return this.values;
    }

    public abstract String getQueryString();

    public abstract ListenableFuture<ResultSet> executeAsync(Session var1, ExecutorService var2);

    public abstract Statement getStatement();

    public abstract void logDMLStatement(String var1);

    protected ListenableFuture<ResultSet> executeAsyncInternal(Session session, AbstractStatementWrapper statementWrapper, ExecutorService executorService) {
        ResultSetFuture resultSetFuture = session.executeAsync(statementWrapper.getStatement());
        return this.asyncUtils.applyLoggingTracingAndCASCheck(resultSetFuture, statementWrapper, executorService);
    }

    public static void writeDMLStartBatch(BatchStatement.Type batchType) {
        switch (batchType) {
            case LOGGED: {
                dmlLogger.debug("");
                dmlLogger.debug("");
                dmlLogger.debug("****** BATCH LOGGED START ******");
                dmlLogger.debug("");
                break;
            }
            case UNLOGGED: {
                dmlLogger.debug("");
                dmlLogger.debug("");
                dmlLogger.debug("****** BATCH UNLOGGED START ******");
                dmlLogger.debug("");
                break;
            }
            case COUNTER: {
                dmlLogger.debug("");
                dmlLogger.debug("");
                dmlLogger.debug("****** BATCH COUNTER START ******");
                dmlLogger.debug("");
            }
        }
    }

    public static void writeDMLEndBatch(BatchStatement.Type batchType, ConsistencyLevel consistencyLevel) {
        switch (batchType) {
            case LOGGED: {
                dmlLogger.debug("");
                dmlLogger.debug("  ****** BATCH LOGGED END  with CONSISTENCY LEVEL [{}] ******", consistencyLevel != null ? consistencyLevel : "DEFAULT");
                dmlLogger.debug("");
                dmlLogger.debug("");
                break;
            }
            case UNLOGGED: {
                dmlLogger.debug("");
                dmlLogger.debug("  ****** BATCH UNLOGGED END with CONSISTENCY LEVEL [{}] ******", consistencyLevel != null ? consistencyLevel : "DEFAULT");
                dmlLogger.debug("");
                dmlLogger.debug("");
                break;
            }
            case COUNTER: {
                dmlLogger.debug("");
                dmlLogger.debug("  ****** BATCH COUNTER END with CONSISTENCY LEVEL [{}] ******", consistencyLevel != null ? consistencyLevel : "DEFAULT");
                dmlLogger.debug("");
                dmlLogger.debug("");
            }
        }
    }

    protected void writeDMLStatementLog(String queryType, String queryString, String consistencyLevel, Object ... values) {
        Logger actualLogger;
        Logger logger = actualLogger = this.displayDMLForEntity ? this.entityLogger : dmlLogger;
        if (actualLogger.isDebugEnabled()) {
            actualLogger.debug("{} : [{}] with CONSISTENCY LEVEL [{}]", new Object[]{queryType, queryString, consistencyLevel});
        }
        if (ArrayUtils.isNotEmpty((Object[])values)) {
            actualLogger.debug("\t bound values : {}", Arrays.asList(values));
        }
    }

    protected boolean isCASInsert(String queryString) {
        return queryString.contains(IF_NOT_EXIST_CLAUSE);
    }

    protected boolean isCASOperation(String queryString) {
        return queryString.contains(IF_CLAUSE);
    }

    public void checkForCASSuccess(ResultSet resultSet) {
        String queryString = this.getQueryString();
        if (this.isCASOperation(queryString)) {
            Row casResult = resultSet.one();
            if (casResult != null && !casResult.getBool(CAS_RESULT_COLUMN)) {
                TreeMap currentValues = new TreeMap();
                for (ColumnDefinitions.Definition columnDef : casResult.getColumnDefinitions()) {
                    Object columnValue;
                    String columnDefName = columnDef.getName();
                    DataType dataType = columnDef.getType();
                    DataType.Name name = dataType.getName();
                    switch (name) {
                        case LIST: {
                            columnValue = casResult.getList(columnDefName, ((DataType)dataType.getTypeArguments().get(0)).asJavaClass());
                            break;
                        }
                        case SET: {
                            columnValue = casResult.getSet(columnDefName, ((DataType)dataType.getTypeArguments().get(0)).asJavaClass());
                            break;
                        }
                        case MAP: {
                            List typeArguments = dataType.getTypeArguments();
                            columnValue = casResult.getMap(columnDefName, ((DataType)typeArguments.get(0)).asJavaClass(), ((DataType)typeArguments.get(1)).asJavaClass());
                            break;
                        }
                        default: {
                            columnValue = this.invoker.invokeOnRowForType(casResult, name.asJavaClass(), columnDefName);
                        }
                    }
                    currentValues.put(columnDefName, columnValue);
                }
                CASResultListener.CASResult.Operation operation = CASResultListener.CASResult.Operation.UPDATE;
                if (this.isCASInsert(queryString)) {
                    operation = CASResultListener.CASResult.Operation.INSERT;
                }
                this.notifyCASError(new CASResultListener.CASResult(operation, TypedMap.fromMap(currentValues)));
            } else {
                this.notifyCASSuccess();
            }
        }
    }

    protected void notifyCASError(CASResultListener.CASResult casResult) {
        if (!this.casResultListener.isPresent()) {
            throw new AchillesLightWeightTransactionException(casResult);
        }
        ((CASResultListener)this.casResultListener.get()).onCASError(casResult);
    }

    protected void notifyCASSuccess() {
        if (this.casResultListener.isPresent()) {
            ((CASResultListener)this.casResultListener.get()).onCASSuccess();
        }
    }

    public void activateQueryTracing() {
        if (this.isTracingEnabled()) {
            this.getStatement().enableTracing();
        }
    }

    public boolean isTracingEnabled() {
        return dmlLogger.isTraceEnabled() || this.traceQueryForEntity;
    }

    public void tracing(ResultSet resultSet) {
        if (this.isTracingEnabled()) {
            Logger actualLogger = this.traceQueryForEntity ? this.entityLogger : dmlLogger;
            for (ExecutionInfo executionInfo : resultSet.getAllExecutionInfo()) {
                actualLogger.trace("Query tracing at host {} with achieved consistency level {} ", (Object)executionInfo.getQueriedHost(), (Object)executionInfo.getAchievedConsistencyLevel());
                actualLogger.trace("****************************");
                if (actualLogger.isTraceEnabled()) {
                    actualLogger.trace(String.format("%1$-80s | %2$-16s | %3$-24s | %4$-20s", "Description", "Source", "Source elapsed in micros", "Thread name"));
                }
                try {
                    QueryTrace queryTrace = executionInfo.getQueryTrace();
                    ArrayList events = new ArrayList(queryTrace.getEvents());
                    Collections.sort(events, EVENT_TRACE_COMPARATOR);
                    for (QueryTrace.Event event : events) {
                        String formatted = String.format("%1$-80s | %2$-16s | %3$-24s | %4$-20s", event.getDescription(), event.getSource(), event.getSourceElapsedMicros(), event.getThreadName());
                        actualLogger.trace(formatted);
                    }
                }
                catch (TraceRetrievalException e) {
                    actualLogger.trace(" ERROR: cannot retrieve trace for query {} because it may not be yet available", (Object)this.getQueryString());
                }
                actualLogger.trace("****************************");
            }
        }
    }

    private static class EventComparator
    implements Comparator<QueryTrace.Event> {
        private EventComparator() {
        }

        @Override
        public int compare(QueryTrace.Event event1, QueryTrace.Event event2) {
            return event1.getSource().toString().compareTo(event2.getSource().toString());
        }
    }
}

