/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.wrapper;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.internal.consistency.ConsistencyConverter;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.internal.statement.wrapper.NativeStatementWrapper;
import info.archinnov.achilles.listener.CASResultListener;
import info.archinnov.achilles.type.ConsistencyLevel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class BatchStatementWrapper
extends AbstractStatementWrapper {
    private BatchStatement.Type batchType;
    private List<AbstractStatementWrapper> statementWrappers;
    private Optional<ConsistencyLevel> consistencyLevelO;
    private Optional<com.datastax.driver.core.ConsistencyLevel> serialConsistencyLevelO;
    private BatchStatement batchStatement;
    private CompositeCASResultListener compositeCASResultListener;

    public BatchStatementWrapper(BatchStatement.Type batchType, List<AbstractStatementWrapper> statementWrappers, Optional<ConsistencyLevel> consistencyLevelO, Optional<com.datastax.driver.core.ConsistencyLevel> serialConsistencyLevel) {
        super(null, null);
        this.batchType = batchType;
        this.statementWrappers = statementWrappers;
        this.consistencyLevelO = consistencyLevelO;
        this.serialConsistencyLevelO = serialConsistencyLevel;
        this.compositeCASResultListener = new CompositeCASResultListener();
        this.casResultListener = Optional.fromNullable((Object)this.compositeCASResultListener);
        this.batchStatement = this.createBatchStatement(batchType, statementWrappers);
    }

    private BatchStatement createBatchStatement(BatchStatement.Type batchType, List<AbstractStatementWrapper> statementWrappers) {
        BatchStatement batch = new BatchStatement(batchType);
        boolean tracingEnabled = false;
        for (AbstractStatementWrapper statementWrapper : statementWrappers) {
            statementWrapper.activateQueryTracing();
            tracingEnabled |= statementWrapper.isTracingEnabled();
            if (statementWrapper.casResultListener.isPresent()) {
                this.compositeCASResultListener.addCASResultListener((CASResultListener)statementWrapper.casResultListener.get());
            }
            if (statementWrapper instanceof NativeStatementWrapper) {
                batch.add(((NativeStatementWrapper)statementWrapper).buildParameterizedStatement());
                continue;
            }
            batch.add(statementWrapper.getStatement());
        }
        if (tracingEnabled) {
            batch.enableTracing();
        }
        if (this.consistencyLevelO.isPresent()) {
            batch.setConsistencyLevel(ConsistencyConverter.getCQLLevel((ConsistencyLevel)this.consistencyLevelO.get()));
        }
        if (this.serialConsistencyLevelO.isPresent()) {
            // empty if block
        }
        return batch;
    }

    @Override
    public String getQueryString() {
        ArrayList<String> queries = new ArrayList<String>();
        for (AbstractStatementWrapper statementWrapper : this.statementWrappers) {
            queries.add(statementWrapper.getQueryString());
        }
        return Joiner.on((String)"\n").join(queries);
    }

    @Override
    public ListenableFuture<ResultSet> executeAsync(Session session, ExecutorService executorService) {
        return super.executeAsyncInternal(session, this, executorService);
    }

    @Override
    public Statement getStatement() {
        return this.batchStatement;
    }

    @Override
    public void logDMLStatement(String indentation) {
        if (dmlLogger.isDebugEnabled() || this.batchStatement.isTracing()) {
            AbstractStatementWrapper.writeDMLStartBatch(this.batchType);
        }
        for (AbstractStatementWrapper statementWrapper : this.statementWrappers) {
            statementWrapper.logDMLStatement(indentation);
        }
        if (dmlLogger.isDebugEnabled() || this.batchStatement.isTracing()) {
            ConsistencyLevel consistencyLevel = this.consistencyLevelO.isPresent() ? (ConsistencyLevel)this.consistencyLevelO.get() : null;
            AbstractStatementWrapper.writeDMLEndBatch(this.batchType, consistencyLevel);
        }
    }

    public ConsistencyLevel getConsistencyLevel() {
        return (ConsistencyLevel)this.consistencyLevelO.get();
    }

    static class CompositeCASResultListener
    implements CASResultListener {
        private final Set<CASResultListener> delegates = new HashSet<CASResultListener>();

        CompositeCASResultListener() {
        }

        private void addCASResultListener(CASResultListener listener) {
            this.delegates.add(listener);
        }

        public void onCASSuccess() {
            for (CASResultListener listener : this.delegates) {
                listener.onCASSuccess();
            }
        }

        public void onCASError(CASResultListener.CASResult casResult) {
            for (CASResultListener listener : this.delegates) {
                listener.onCASError(casResult);
            }
        }
    }
}

