/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.wrapper;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.listener.CASResultListener;
import java.util.concurrent.ExecutorService;

public class BoundStatementWrapper
extends AbstractStatementWrapper {
    private BoundStatement boundStatement;

    public BoundStatementWrapper(Class<?> entityClass, BoundStatement bs, Object[] values, ConsistencyLevel consistencyLevel, Optional<CASResultListener> casResultListener, Optional<ConsistencyLevel> serialConsistencyLevel) {
        super(entityClass, values);
        this.casResultListener = casResultListener;
        this.boundStatement = bs;
        this.boundStatement.setConsistencyLevel(consistencyLevel);
        if (serialConsistencyLevel.isPresent()) {
            this.boundStatement.setSerialConsistencyLevel((ConsistencyLevel)serialConsistencyLevel.get());
        }
    }

    @Override
    public ListenableFuture<ResultSet> executeAsync(Session session, ExecutorService executorService) {
        this.activateQueryTracing();
        return super.executeAsyncInternal(session, this, executorService);
    }

    public BoundStatement getStatement() {
        return this.boundStatement;
    }

    @Override
    public String getQueryString() {
        return this.boundStatement.preparedStatement().getQueryString();
    }

    @Override
    public void logDMLStatement(String indentation) {
        if (dmlLogger.isDebugEnabled() || this.displayDMLForEntity) {
            PreparedStatement ps = this.boundStatement.preparedStatement();
            String queryType = "Bound statement";
            String queryString = ps.getQueryString();
            String consistencyLevel = this.boundStatement.getConsistencyLevel() == null ? "DEFAULT" : this.boundStatement.getConsistencyLevel().name();
            this.writeDMLStatementLog(queryType, queryString, consistencyLevel, this.values);
        }
    }
}

