/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.wrapper;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.listener.CASResultListener;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.ArrayUtils;

public class NativeStatementWrapper
extends AbstractStatementWrapper {
    private RegularStatement regularStatement;

    public NativeStatementWrapper(Class<?> entityClass, RegularStatement regularStatement, Object[] values, Optional<CASResultListener> casResultListener) {
        super(entityClass, values);
        this.regularStatement = regularStatement;
        this.casResultListener = casResultListener;
    }

    @Override
    public String getQueryString() {
        return this.regularStatement.getQueryString();
    }

    @Override
    public ListenableFuture<ResultSet> executeAsync(Session session, ExecutorService executorService) {
        this.activateQueryTracing();
        return super.executeAsyncInternal(session, this, executorService);
    }

    @Override
    public Statement getStatement() {
        return this.buildParameterizedStatement();
    }

    @Override
    public void logDMLStatement(String indentation) {
        if (dmlLogger.isDebugEnabled() || this.displayDMLForEntity) {
            String queryType = "Parameterized statement";
            String queryString = this.regularStatement.getQueryString();
            String consistencyLevel = this.regularStatement.getConsistencyLevel() == null ? "DEFAULT" : this.regularStatement.getConsistencyLevel().name();
            this.writeDMLStatementLog(queryType, queryString, consistencyLevel, this.values);
        }
    }

    public Statement buildParameterizedStatement() {
        if (ArrayUtils.isEmpty((Object[])this.regularStatement.getValues()) && ArrayUtils.isNotEmpty((Object[])this.values)) {
            SimpleStatement statement = new SimpleStatement(this.regularStatement.getQueryString(), this.values);
            if (this.regularStatement.getConsistencyLevel() != null) {
                statement.setConsistencyLevel(this.regularStatement.getConsistencyLevel());
            }
            if (this.regularStatement.getSerialConsistencyLevel() != null) {
                statement.setSerialConsistencyLevel(this.regularStatement.getSerialConsistencyLevel());
            }
            return statement;
        }
        return this.regularStatement;
    }
}

