/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.table;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TableMetadata;
import com.google.common.collect.ComparisonChain;
import java.util.List;

public class ColumnMetaDataComparator {
    public boolean isEqual(ColumnMetadata source, ColumnMetadata target) {
        boolean isEqual;
        String sourceName = source.getName();
        TableMetadata sourceTable = source.getTable();
        DataType sourceType = source.getType();
        Class sourceClass = sourceType.asJavaClass();
        List sourceTypeParams = sourceType.getTypeArguments();
        String targetName = target.getName();
        TableMetadata targetTable = target.getTable();
        DataType targetType = target.getType();
        Class targetClass = targetType.asJavaClass();
        List targetTypeParams = targetType.getTypeArguments();
        boolean isPartiallyEqual = ComparisonChain.start().compare((Comparable)((Object)sourceName), (Comparable)((Object)targetName)).compare((Comparable)((Object)sourceTable.getName()), (Comparable)((Object)targetTable.getName())).compare((Comparable)sourceType.getName(), (Comparable)targetType.getName()).compareFalseFirst(sourceType.isCollection(), targetType.isCollection()).result() == 0;
        boolean isSameClass = sourceClass.equals(targetClass);
        boolean bothHaveTypeParameters = sourceTypeParams != null && targetTypeParams != null || sourceTypeParams == null && targetTypeParams == null;
        boolean bl = isEqual = isPartiallyEqual && isSameClass && bothHaveTypeParameters;
        if (isEqual && sourceTypeParams != null) {
            boolean bl2 = isEqual = sourceTypeParams.size() == targetTypeParams.size();
            if (isEqual) {
                for (int i = 0; i < sourceTypeParams.size(); ++i) {
                    boolean sameParamType;
                    DataType sourceParamType = (DataType)sourceTypeParams.get(i);
                    DataType targetParamType = (DataType)targetTypeParams.get(i);
                    boolean bl3 = sameParamType = ComparisonChain.start().compare((Comparable)sourceParamType.getName(), (Comparable)targetParamType.getName()).result() == 0;
                    if (sameParamType) continue;
                    return false;
                }
            }
        }
        return isEqual;
    }

    public static enum Singleton {
        INSTANCE;

        private final ColumnMetaDataComparator instance = new ColumnMetaDataComparator();

        public ColumnMetaDataComparator get() {
            return this.instance;
        }
    }
}

